/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.contrib.Layoutable;
import org.jhotdraw.contrib.Layouter;
import org.jhotdraw.contrib.StandardLayouter;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class GraphicalCompositeFigure
extends CompositeFigure
implements Layoutable {
    private Figure myPresentationFigure;
    private Layouter myLayouter;
    private static final long serialVersionUID = 1265742491024232713L;

    public GraphicalCompositeFigure() {
        this(new RectangleFigure());
    }

    public GraphicalCompositeFigure(Figure newPresentationFigure) {
        this.setPresentationFigure(newPresentationFigure);
        this.initialize();
    }

    protected void initialize() {
        if (this.getLayouter() != null) {
            this.setLayouter(this.getLayouter().create(this));
        } else {
            this.setLayouter(new StandardLayouter(this));
        }
    }

    public Object clone() {
        Object cloneObject = super.clone();
        ((GraphicalCompositeFigure)cloneObject).initialize();
        return cloneObject;
    }

    public Rectangle displayBox() {
        return this.getPresentationFigure().displayBox();
    }

    public void basicDisplayBox(Point origin, Point corner) {
        Rectangle r = this.getLayouter().layout(origin, corner);
        this.getPresentationFigure().basicDisplayBox(r.getLocation(), new Point((int)r.getMaxX(), (int)r.getMaxY()));
    }

    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        this.getPresentationFigure().moveBy(dx, dy);
    }

    public void update() {
        this.willChange();
        this.layout();
        this.change();
        this.changed();
    }

    public void draw(Graphics g) {
        this.getPresentationFigure().draw(g);
        super.draw(g);
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, handles);
        return new HandleEnumerator(handles);
    }

    public Object getAttribute(String name) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(attributeConstant);
        }
        return super.getAttribute(attributeConstant);
    }

    public void setAttribute(String name, Object value) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(name, value);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(attributeConstant, value);
        } else {
            super.setAttribute(attributeConstant, value);
        }
    }

    public void setPresentationFigure(Figure newPresentationFigure) {
        this.myPresentationFigure = newPresentationFigure;
    }

    public Figure getPresentationFigure() {
        return this.myPresentationFigure;
    }

    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle r = this.getLayouter().calculateLayout(this.displayBox().getLocation(), this.displayBox().getLocation());
            this.displayBox(r.getLocation(), new Point(r.x + r.width, r.y + r.height));
        }
    }

    public void setLayouter(Layouter newLayouter) {
        this.myLayouter = newLayouter;
    }

    public Layouter getLayouter() {
        return this.myLayouter;
    }

    protected void change() {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            if (this.includes(e.getFigure())) {
                Rectangle r = this.invalidateRectangle(this.displayBox());
                this.listener().figureRequestRemove(new FigureChangeEvent(this, r, e));
            } else {
                super.figureRequestRemove(e);
            }
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setPresentationFigure((Figure)dr.readStorable());
        this.setLayouter((Layouter)dr.readStorable());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getPresentationFigure());
        dw.writeStorable(this.getLayouter());
    }
}

