/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jhotdraw.contrib.ChopDiamondConnector;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Connector;

public class DiamondFigure
extends RectangleFigure {
    public DiamondFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public DiamondFigure(Point origin, Point corner) {
        super(origin, corner);
    }

    protected Polygon getPolygon() {
        Rectangle r = this.displayBox();
        Polygon p = new Polygon();
        p.addPoint(r.x, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y);
        p.addPoint(r.x + r.width, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y + r.height);
        return p;
    }

    public void draw(Graphics g) {
        Polygon p = this.getPolygon();
        g.setColor(this.getFillColor());
        g.fillPolygon(p);
        g.setColor(this.getFrameColor());
        g.drawPolygon(p);
    }

    public Insets connectionInsets() {
        Rectangle r = this.displayBox();
        return new Insets(r.height / 2, r.width / 2, r.height / 2, r.width / 2);
    }

    public boolean containsPoint(int x, int y) {
        return this.getPolygon().contains(x, y);
    }

    public Point chop(Point p) {
        return PolygonFigure.chop(this.getPolygon(), p);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopDiamondConnector(this);
    }
}

