/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Painter;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;

public class ClippingUpdateStrategy
implements Painter {
    public void draw(Graphics g, DrawingView view) {
        Rectangle viewClipRectangle = g.getClipBounds();
        if (viewClipRectangle == null) {
            view.drawAll(g);
            return;
        }
        FigureEnumeration fe = view.drawing().figures();
        List figuresList = CollectionsFactory.current().createList(1000);
        while (fe.hasNextFigure()) {
            Figure fig = fe.nextFigure();
            Rectangle r = fig.displayBox();
            if (r.width <= 0) {
                r.width = 1;
            }
            if (r.height <= 0) {
                r.height = 1;
            }
            if (!r.intersects(viewClipRectangle)) continue;
            figuresList.add(fig);
        }
        FigureEnumerator clippedFE = new FigureEnumerator(figuresList);
        view.draw(g, clippedFE);
    }
}

