/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.GroupCommand;
import org.jhotdraw.figures.UngroupCommand;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.BufferedUpdateStrategy;
import org.jhotdraw.standard.ChangeAttributeCommand;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.DuplicateCommand;
import org.jhotdraw.standard.SelectionTool;
import org.jhotdraw.standard.SimpleUpdateStrategy;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.CommandButton;
import org.jhotdraw.util.CommandChoice;
import org.jhotdraw.util.Filler;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteLayout;
import org.jhotdraw.util.PaletteListener;
import org.jhotdraw.util.StandardVersionControlStrategy;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoManager;
import org.jhotdraw.util.VersionControlStrategy;
import org.jhotdraw.util.VersionManagement;
import org.jhotdraw.util.VersionRequester;

public class DrawApplet
extends JApplet
implements DrawingEditor,
PaletteListener,
VersionRequester {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient DrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient JButton fUpdateButton;
    private transient JComboBox fFrameColor;
    private transient JComboBox fFillColor;
    private transient JComboBox fTextColor;
    private transient JComboBox fArrowChoice;
    private transient JComboBox fFontChoice;
    private transient UndoManager myUndoManager;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/org/jhotdraw/";
    public static final String IMAGES = "/org/jhotdraw/images/";

    public void init() {
        this.createIconkit();
        this.getVersionControlStrategy().assertCompatibleVersion();
        this.setUndoManager(new UndoManager());
        this.getContentPane().setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        JPanel attributes = this.createAttributesPanel();
        this.createAttributeChoices(attributes);
        this.getContentPane().add("North", attributes);
        JPanel toolPanel = this.createToolPalette();
        this.createTools(toolPanel);
        this.getContentPane().add("West", toolPanel);
        this.getContentPane().add("Center", (Component)((Object)this.view()));
        JPanel buttonPalette = this.createButtonPanel();
        this.createButtons(buttonPalette);
        this.getContentPane().add("South", buttonPalette);
        this.initDrawing();
        this.setupAttributes();
    }

    public void addViewChangeListener(ViewChangeListener vsl) {
    }

    public void removeViewChangeListener(ViewChangeListener vsl) {
    }

    protected Iconkit createIconkit() {
        return new Iconkit(this);
    }

    protected JPanel createAttributesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createAttributeChoices(JPanel panel) {
        panel.add(new JLabel("Fill"));
        this.fFillColor = this.createColorChoice(FigureAttributeConstant.FILL_COLOR);
        panel.add(this.fFillColor);
        panel.add(new JLabel("Text"));
        this.fTextColor = this.createColorChoice(FigureAttributeConstant.TEXT_COLOR);
        panel.add(this.fTextColor);
        panel.add(new JLabel("Pen"));
        this.fFrameColor = this.createColorChoice(FigureAttributeConstant.FRAME_COLOR);
        panel.add(this.fFrameColor);
        panel.add(new JLabel("Arrow"));
        CommandChoice choice = new CommandChoice();
        this.fArrowChoice = choice;
        FigureAttributeConstant arrowMode = FigureAttributeConstant.ARROW_MODE;
        choice.addItem(new ChangeAttributeCommand("none", arrowMode, new Integer(0), this));
        choice.addItem(new ChangeAttributeCommand("at Start", arrowMode, new Integer(1), this));
        choice.addItem(new ChangeAttributeCommand("at End", arrowMode, new Integer(2), this));
        choice.addItem(new ChangeAttributeCommand("at Both", arrowMode, new Integer(3), this));
        panel.add(this.fArrowChoice);
        panel.add(new JLabel("Font"));
        this.fFontChoice = this.createFontChoice();
        panel.add(this.fFontChoice);
    }

    protected JComboBox createColorChoice(FigureAttributeConstant attribute) {
        CommandChoice choice = new CommandChoice();
        int i = 0;
        while (i < ColorMap.size()) {
            choice.addItem(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this));
            ++i;
        }
        return choice;
    }

    protected JComboBox createFontChoice() {
        CommandChoice choice = new CommandChoice();
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            choice.addItem(new ChangeAttributeCommand(fonts[i], FigureAttributeConstant.FONT_NAME, fonts[i], this));
            ++i;
        }
        return choice;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createButtons(JPanel panel) {
        panel.add(new Filler(24, 20));
        JComboBox<String> drawingChoice = new JComboBox<String>();
        drawingChoice.addItem(fgUntitled);
        String param = this.getParameter("DRAWINGS");
        if (param == null) {
            param = "";
        }
        StringTokenizer st = new StringTokenizer(param);
        while (st.hasMoreTokens()) {
            drawingChoice.addItem(st.nextToken());
        }
        if (drawingChoice.getItemCount() > 1) {
            panel.add(drawingChoice);
        } else {
            panel.add(new JLabel(fgUntitled));
        }
        drawingChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DrawApplet.this.loadDrawing((String)e.getItem());
                }
            }
        });
        panel.add(new Filler(6, 20));
        JButton button = new CommandButton(new DeleteCommand("Delete", this));
        panel.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this));
        panel.add(button);
        button = new CommandButton(new GroupCommand("Group", this));
        panel.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this));
        panel.add(button);
        button = new JButton("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawApplet.this.showHelp();
            }
        });
        panel.add(button);
        this.fUpdateButton = new JButton("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (DrawApplet.this.fSimpleUpdate) {
                    DrawApplet.this.setBufferedDisplayUpdate();
                } else {
                    DrawApplet.this.setSimpleDisplayUpdate();
                }
            }
        });
    }

    protected JPanel createToolPalette() {
        JPanel palette = new JPanel();
        palette.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return palette;
    }

    protected void createTools(JPanel palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/org/jhotdraw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected DrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton button, boolean inside) {
        if (inside) {
            this.showStatus(button.name());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void figureSelectionChanged(DrawingView view) {
        this.setupAttributes();
    }

    public void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.view().setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool t, String name) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = t;
        if (this.fTool != null) {
            this.showStatus(name);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String param) {
        if (param == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String filename = this.getParameter(param);
        if (filename != null) {
            this.readDrawing(filename);
        }
    }

    private void readDrawing(String filename) {
        this.toolDone();
        String type = this.guessType(filename);
        if (type.equals("storable")) {
            this.readFromStorableInput(filename);
        } else if (type.equals("serialized")) {
            this.readFromObjectInput(filename);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            StorableInput input = new StorableInput(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readStorable();
            this.view().setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error:" + e);
        }
    }

    private void readFromObjectInput(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            ObjectInputStream input = new ObjectInputStream(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readObject();
            this.view().setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error: " + e);
        }
        catch (ClassNotFoundException e) {
            this.initDrawing();
            this.showStatus("Class not found: " + e);
        }
    }

    private String guessType(String file) {
        if (file.endsWith(".draw")) {
            return "storable";
        }
        if (file.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    private void setupAttributes() {
        Color frameColor = (Color)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FRAME_COLOR);
        Color fillColor = (Color)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FILL_COLOR);
        Integer arrowMode = (Integer)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.ARROW_MODE);
        String fontName = (String)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FONT_NAME);
        FigureEnumeration fe = this.view().selection();
        while (fe.hasNextFigure()) {
            Figure f = fe.nextFigure();
            frameColor = (Color)f.getAttribute(FigureAttributeConstant.FRAME_COLOR);
            fillColor = (Color)f.getAttribute(FigureAttributeConstant.FILL_COLOR);
            arrowMode = (Integer)f.getAttribute(FigureAttributeConstant.ARROW_MODE);
            fontName = (String)f.getAttribute(FigureAttributeConstant.FONT_NAME);
        }
        this.fFrameColor.setSelectedIndex(ColorMap.colorIndex(frameColor));
        this.fFillColor.setSelectedIndex(ColorMap.colorIndex(fillColor));
        if (arrowMode != null) {
            this.fArrowChoice.setSelectedIndex(arrowMode);
        }
        if (fontName != null) {
            this.fFontChoice.setSelectedItem(fontName);
        }
    }

    protected void setSimpleDisplayUpdate() {
        this.view().setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setText("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.view().setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setText("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        try {
            String appletPath = this.getClass().getName().replace('.', '/');
            URL url = new URL(this.getCodeBase(), String.valueOf(appletPath) + "Help.html");
            this.getAppletContext().showDocument(url, "Help");
        }
        catch (IOException e) {
            this.showStatus("Help file not found");
        }
    }

    protected void setUndoManager(UndoManager newUndoManager) {
        this.myUndoManager = newUndoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected VersionControlStrategy getVersionControlStrategy() {
        return new StandardVersionControlStrategy(this);
    }

    public String[] getRequiredVersions() {
        String[] requiredVersions = new String[]{VersionManagement.getPackageVersion(DrawApplet.class.getPackage())};
        return requiredVersions;
    }
}

