/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import org.postgresql.PGStatement;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.jdbc1.AbstractJdbc1ResultSet;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;

public abstract class AbstractJdbc1Statement
implements PGStatement {
    protected AbstractJdbc1Connection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultSet result = null;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    private String[] m_origSqlFragments;
    private String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected String[] m_bindTypes = new String[0];
    private String m_statementName = null;
    private boolean m_useServerPrepare = false;
    private static int m_preparedCount = 1;
    private static final String JDBC_SYNTAX = "{[? =] call <some_function> ([? [,?]*]) }";
    private static final String RESULT_COLUMN = "result";
    private String originalSql = "";
    private boolean isFunction;
    private int functionReturnType;
    private int testReturn;
    private boolean returnTypeSet;
    protected Object callResult;
    private static final String PG_TEXT = "text";
    private static final String PG_INTEGER = "integer";
    private static final String PG_INT2 = "int2";
    private static final String PG_INT8 = "int8";
    private static final String PG_NUMERIC = "numeric";
    private static final String PG_FLOAT = "float";
    private static final String PG_DOUBLE = "double";
    private static final String PG_BOOLEAN = "boolean";
    private static final String PG_DATE = "date";
    private static final String PG_TIME = "time";
    private static final String PG_TIMESTAMPTZ = "timestamptz";
    private static final String PG_BYTEA = "bytea";

    public AbstractJdbc1Statement(AbstractJdbc1Connection connection) {
        this.connection = connection;
    }

    public AbstractJdbc1Statement(AbstractJdbc1Connection connection, String p_sql) throws SQLException {
        this.connection = connection;
        this.parseSqlStmt(p_sql);
    }

    protected void parseSqlStmt(String p_sql) throws SQLException {
        String l_sql = p_sql;
        l_sql = this.replaceProcessing(l_sql);
        if (this instanceof CallableStatement) {
            l_sql = this.modifyJdbcCall(l_sql);
        }
        Vector<String> v = new Vector<String>();
        boolean inQuotes = false;
        int lastParmEnd = 0;
        int i = 0;
        while (i < l_sql.length()) {
            char c = l_sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == '?' && !inQuotes) {
                v.addElement(l_sql.substring(lastParmEnd, i));
                lastParmEnd = i + 1;
            }
            ++i;
        }
        v.addElement(l_sql.substring(lastParmEnd, l_sql.length()));
        this.m_sqlFragments = new String[v.size()];
        this.m_binds = new String[v.size() - 1];
        this.m_bindTypes = new String[v.size() - 1];
        i = 0;
        while (i < this.m_sqlFragments.length) {
            this.m_sqlFragments[i] = (String)v.elementAt(i);
            ++i;
        }
    }

    public ResultSet executeQuery(String p_sql) throws SQLException {
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            this.connection.ExecSQL("DEALLOCATE " + this.m_statementName);
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
        }
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        while (this.result != null && !((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((AbstractJdbc1ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String p_sql) throws SQLException {
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            this.connection.ExecSQL("DEALLOCATE " + this.m_statementName);
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
        }
        return this.executeUpdate();
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        if (((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public boolean execute(String p_sql) throws SQLException {
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            this.connection.ExecSQL("DEALLOCATE " + this.m_statementName);
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
        }
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        ResultSet rs;
        if (this.isFunction && !this.returnTypeSet) {
            throw new PSQLException("postgresql.call.noreturntype");
        }
        if (this.isFunction) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = PG_TEXT;
        }
        if (this.result != null && (rs = this.getResultSet()) != null) {
            rs.close();
        }
        if (this.m_useServerPrepare) {
            if (this.m_statementName == null) {
                this.m_statementName = "JDBC_STATEMENT_" + m_preparedCount++;
                this.m_origSqlFragments = new String[this.m_sqlFragments.length];
                this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
                System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
                this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
                if (this.m_sqlFragments.length > 1) {
                    this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                    int i = 1;
                    while (i < this.m_bindTypes.length) {
                        this.m_executeSqlFragments[i] = ", ";
                        ++i;
                    }
                    this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
                }
                StringBuffer i = this.sbuf;
                synchronized (i) {
                    int i2;
                    this.sbuf.setLength(0);
                    this.sbuf.append("PREPARE ");
                    this.sbuf.append(this.m_statementName);
                    if (this.m_origSqlFragments.length > 1) {
                        this.sbuf.append("(");
                        i2 = 0;
                        while (i2 < this.m_bindTypes.length - 1) {
                            this.sbuf.append(this.m_bindTypes[i2]);
                            this.sbuf.append(", ");
                            ++i2;
                        }
                        this.sbuf.append(this.m_bindTypes[this.m_bindTypes.length - 1]);
                        this.sbuf.append(")");
                    }
                    this.sbuf.append(" AS ");
                    this.sbuf.append(this.m_origSqlFragments[0]);
                    i2 = 1;
                    while (i2 < this.m_origSqlFragments.length) {
                        this.sbuf.append(" $");
                        this.sbuf.append(i2);
                        this.sbuf.append(" ");
                        this.sbuf.append(this.m_origSqlFragments[i2]);
                        ++i2;
                    }
                    this.sbuf.append("; ");
                    this.sbuf.append(this.m_executeSqlFragments[0]);
                    this.m_sqlFragments[0] = this.sbuf.toString();
                    System.arraycopy(this.m_executeSqlFragments, 1, this.m_sqlFragments, 1, this.m_sqlFragments.length - 1);
                }
            } else {
                this.m_sqlFragments = this.m_executeSqlFragments;
            }
        }
        this.result = this.connection.ExecSQL(this.m_sqlFragments, this.m_binds, (Statement)((Object)this));
        if (this.isFunction) {
            if (!((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet()) {
                throw new PSQLException("postgresql.call.noreturnval");
            }
            if (!this.result.next()) {
                throw new PSQLException("postgresql.call.noreturnval");
            }
            this.callResult = this.result.getObject(1);
            int columnType = this.result.getMetaData().getColumnType(1);
            if (columnType != this.functionReturnType) {
                throw new PSQLException("postgresql.call.wrongrtntype", new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType});
            }
            this.result.close();
            return true;
        }
        return this.result != null && ((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet();
    }

    public void setCursorName(String name) throws SQLException {
        this.connection.setCursorName(name);
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((AbstractJdbc1ResultSet)((Object)this.result)).getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((AbstractJdbc1ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((AbstractJdbc1ResultSet)((Object)this.result)).getStatusString();
    }

    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.replaceProcessingEnabled = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    public void addWarning(String msg) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(msg));
        } else {
            this.warnings = new SQLWarning(msg);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void cancel() throws SQLException {
        throw new PSQLException("postgresql.unimplemented");
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.result != null && ((AbstractJdbc1ResultSet)((Object)this.result)).reallyResultSet()) {
            return this.result;
        }
        return null;
    }

    public void close() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            rs.close();
        }
        if (this.m_useServerPrepare && this.m_statementName != null) {
            this.connection.ExecSQL("DEALLOCATE " + this.m_statementName);
        }
        this.result = null;
    }

    protected String replaceProcessing(String p_sql) {
        if (this.replaceProcessingEnabled) {
            StringBuffer newsql = new StringBuffer(p_sql.length());
            int state = 0;
            int i = -1;
            int len = p_sql.length();
            while (++i < len) {
                char c = p_sql.charAt(i);
                switch (state) {
                    case 0: {
                        if (c == '\'') {
                            state = 1;
                        } else if (c == '{' && i + 1 < len) {
                            char next = p_sql.charAt(i + 1);
                            if (next == 'd') {
                                state = 3;
                                ++i;
                                break;
                            }
                            if (next == 't') {
                                state = 3;
                                i += i + 2 < len && p_sql.charAt(i + 2) == 's' ? 2 : 1;
                                break;
                            }
                        }
                        newsql.append(c);
                        break;
                    }
                    case 1: {
                        if (c == '\'') {
                            state = 0;
                        } else if (c == '\\') {
                            state = 2;
                        }
                        newsql.append(c);
                        break;
                    }
                    case 2: {
                        state = 1;
                        newsql.append(c);
                        break;
                    }
                    case 3: {
                        if (c == '}') {
                            state = 0;
                            break;
                        }
                        newsql.append(c);
                    }
                }
            }
            return newsql.toString();
        }
        return p_sql;
    }

    public int getInsertedOID() throws SQLException {
        if (this.result == null) {
            return 0;
        }
        return (int)((AbstractJdbc1ResultSet)((Object)this.result)).getLastOID();
    }

    public long getLastOID() throws SQLException {
        if (this.result == null) {
            return 0L;
        }
        return ((AbstractJdbc1ResultSet)((Object)this.result)).getLastOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String l_pgType;
        switch (sqlType) {
            case 4: {
                l_pgType = PG_INTEGER;
                break;
            }
            case -6: 
            case 5: {
                l_pgType = PG_INT2;
                break;
            }
            case -5: {
                l_pgType = PG_INT8;
                break;
            }
            case 6: 
            case 7: {
                l_pgType = PG_FLOAT;
                break;
            }
            case 8: {
                l_pgType = PG_DOUBLE;
                break;
            }
            case 2: 
            case 3: {
                l_pgType = PG_NUMERIC;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                l_pgType = PG_TEXT;
                break;
            }
            case 91: {
                l_pgType = PG_DATE;
                break;
            }
            case 92: {
                l_pgType = PG_TIME;
                break;
            }
            case 93: {
                l_pgType = PG_TIMESTAMPTZ;
                break;
            }
            case -3: 
            case -2: {
                l_pgType = PG_BYTEA;
                break;
            }
            case 1111: {
                l_pgType = PG_TEXT;
                break;
            }
            default: {
                l_pgType = PG_TEXT;
            }
        }
        this.bind(parameterIndex, "null", l_pgType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.bind(parameterIndex, x ? "'t'" : "'f'", PG_BOOLEAN);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), PG_TEXT);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), PG_INT2);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), PG_INTEGER);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.bind(parameterIndex, Long.toString(x), PG_INT8);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.bind(parameterIndex, Float.toString(x), PG_FLOAT);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.bind(parameterIndex, Double.toString(x), PG_DOUBLE);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bind(parameterIndex, x.toString(), PG_NUMERIC);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setString(parameterIndex, x, PG_TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x, String type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(x.length());
                this.sbuf.append('\'');
                int i = 0;
                while (i < x.length()) {
                    char c = x.charAt(i);
                    if (c == '\\' || c == '\'') {
                        this.sbuf.append('\\');
                    }
                    this.sbuf.append(c);
                    ++i;
                }
                this.sbuf.append('\'');
                this.bind(parameterIndex, this.sbuf.toString(), type);
            }
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            if (null == x) {
                this.setNull(parameterIndex, -3);
            } else {
                this.setString(parameterIndex, PGbytea.toPGString(x), PG_TEXT);
            }
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            lob.write(x);
            lob.close();
            this.setInt(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 91);
        } else {
            this.bind(parameterIndex, "'" + x.toString() + "'", PG_DATE);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 92);
        } else {
            this.bind(parameterIndex, "'" + x.toString() + "'", PG_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 93);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(32);
                this.sbuf.append("'");
                int l_year = x.getYear() + 1900;
                this.sbuf.append(l_year);
                this.sbuf.append('-');
                int l_month = x.getMonth() + 1;
                if (l_month < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_month);
                this.sbuf.append('-');
                int l_day = x.getDate();
                if (l_day < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_day);
                this.sbuf.append(' ');
                int l_hours = x.getHours();
                if (l_hours < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_hours);
                this.sbuf.append(':');
                int l_minutes = x.getMinutes();
                if (l_minutes < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_minutes);
                this.sbuf.append(':');
                int l_seconds = x.getSeconds();
                if (l_seconds < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_seconds);
                char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] l_nanos = Integer.toString(x.getNanos()).toCharArray();
                System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
                this.sbuf.append('.');
                if (this.connection.haveMinimumServerVersion("7.2")) {
                    this.sbuf.append(l_decimal, 0, 6);
                } else {
                    this.sbuf.append(l_decimal, 0, 2);
                }
                int l_offset = -x.getTimezoneOffset();
                int l_houros = l_offset / 60;
                if (l_houros >= 0) {
                    this.sbuf.append('+');
                } else {
                    this.sbuf.append('-');
                }
                if (l_houros > -10 && l_houros < 10) {
                    this.sbuf.append('0');
                }
                if (l_houros >= 0) {
                    this.sbuf.append(l_houros);
                } else {
                    this.sbuf.append(-l_houros);
                }
                int l_minos = l_offset - l_houros * 60;
                if (l_minos != 0) {
                    if (l_minos < 10) {
                        this.sbuf.append('0');
                    }
                    this.sbuf.append(l_minos);
                }
                this.sbuf.append("'");
                this.bind(parameterIndex, this.sbuf.toString(), PG_TIMESTAMPTZ);
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                InputStreamReader l_inStream = new InputStreamReader(x, "ASCII");
                char[] l_chars = new char[length];
                int l_charsRead = l_inStream.read(l_chars, 0, length);
                this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), PG_TEXT);
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", l_uee);
            }
            catch (IOException l_ioe) {
                throw new PSQLException("postgresql.unusual", l_ioe);
            }
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                InputStreamReader l_inStream = new InputStreamReader(x, "UTF-8");
                char[] l_chars = new char[length];
                int l_charsRead = l_inStream.read(l_chars, 0, length);
                this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), PG_TEXT);
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", l_uee);
            }
            catch (IOException l_ioe) {
                throw new PSQLException("postgresql.unusual", l_ioe);
            }
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            int l_bytesRead;
            byte[] l_bytes = new byte[length];
            try {
                l_bytesRead = x.read(l_bytes, 0, length);
            }
            catch (IOException l_ioe) {
                throw new PSQLException("postgresql.unusual", l_ioe);
            }
            if (l_bytesRead == length) {
                this.setBytes(parameterIndex, l_bytes);
            } else {
                byte[] l_bytes2 = new byte[l_bytesRead];
                System.arraycopy(l_bytes, 0, l_bytes2, 0, l_bytesRead);
                this.setBytes(parameterIndex, l_bytes2);
            }
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                int p = 0;
                while (c > -1 && p < length) {
                    los.write(c);
                    c = x.read();
                    ++p;
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException("postgresql.unusual", se);
            }
            this.setInt(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.m_binds.length) {
            this.m_binds[i] = null;
            this.m_bindTypes[i] = null;
            ++i;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                this.bind(parameterIndex, x.toString(), PG_INTEGER);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", PG_BOOLEAN);
                    break;
                }
                this.bind(parameterIndex, x.toString(), PG_NUMERIC);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            case 91: {
                this.setDate(parameterIndex, (Date)x);
                break;
            }
            case 92: {
                this.setTime(parameterIndex, (Time)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case -7: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "TRUE" : "FALSE", PG_TEXT);
                    break;
                }
                throw new PSQLException("postgresql.prep.type");
            }
            case -3: 
            case -2: {
                this.setObject(parameterIndex, x);
                break;
            }
            case 1111: {
                this.setString(parameterIndex, ((PGobject)x).getValue(), PG_TEXT);
                break;
            }
            default: {
                throw new PSQLException("postgresql.prep.type");
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            int l_sqlType = x instanceof String ? 12 : (x instanceof BigDecimal ? 3 : (x instanceof Short ? 5 : (x instanceof Integer ? 4 : (x instanceof Long ? -5 : (x instanceof Float ? 6 : (x instanceof Double ? 8 : (x instanceof byte[] ? -2 : (x instanceof Date ? 91 : (x instanceof Time ? 92 : (x instanceof Timestamp ? 93 : (x instanceof Boolean ? 1111 : 1111)))))))))));
            this.setNull(parameterIndex, l_sqlType);
            return;
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof PGobject) {
            this.setString(parameterIndex, ((PGobject)x).getValue(), PG_TEXT);
        } else {
            this.setSerialize(parameterIndex, this.connection.storeObject(x), x.getClass().getName());
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (parameterIndex != 1) {
            throw new PSQLException("postgresql.call.noinout");
        }
        if (!this.isFunction) {
            throw new PSQLException("postgresql.call.procasfunc", (Object)this.originalSql);
        }
        this.functionReturnType = sqlType;
        this.testReturn = sqlType;
        if (this.functionReturnType == 1 || this.functionReturnType == -1) {
            this.testReturn = 12;
        } else if (this.functionReturnType == 6) {
            this.testReturn = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public boolean wasNull() throws SQLException {
        return this.callResult == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult == null) {
            return false;
        }
        return (Boolean)this.callResult;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -6, "Byte");
        if (this.callResult == null) {
            return 0;
        }
        return (byte)((Integer)this.callResult).intValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult == null) {
            return 0;
        }
        return (short)((Integer)this.callResult).intValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult == null) {
            return 0;
        }
        return (Integer)this.callResult;
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult == null) {
            return 0L;
        }
        return (Long)this.callResult;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult == null) {
            return 0.0f;
        }
        return ((Float)this.callResult).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult == null) {
            return 0.0;
        }
        return (Double)this.callResult;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -3, "Bytes");
        return (byte[])this.callResult;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        return this.callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            int i = 0;
            while (i < this.m_binds.length) {
                if (this.m_binds[i] == null) {
                    this.sbuf.append('?');
                } else {
                    this.sbuf.append(this.m_sqlFragments[i]);
                }
                this.sbuf.append(this.m_binds[i]);
                ++i;
            }
            this.sbuf.append(this.m_sqlFragments[this.m_binds.length]);
            return this.sbuf.toString();
        }
    }

    protected void bind(int paramIndex, Object s, String type) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.m_binds.length) {
            throw new PSQLException("postgresql.prep.range");
        }
        if (paramIndex == 1 && this.isFunction) {
            throw new PSQLException("postgresql.call.funcover");
        }
        this.m_binds[paramIndex - 1] = s;
        this.m_bindTypes[paramIndex - 1] = type;
    }

    private void setSerialize(int parameterIndex, long x, String classname) throws SQLException {
        String tablename = Serialize.toPostgreSQL((Connection)((Object)this.connection), classname);
        DriverManager.println("setSerialize: setting " + x + "::" + tablename);
        this.bind(parameterIndex, Long.toString(x) + "::" + tablename, PG_TEXT);
    }

    private String modifyJdbcCall(String p_sql) throws SQLException {
        if (!p_sql.trim().startsWith("{")) {
            return p_sql;
        }
        this.originalSql = p_sql;
        String l_sql = p_sql;
        int index = l_sql.indexOf("=");
        boolean isValid = true;
        if (index != -1) {
            this.isFunction = true;
            boolean bl = isValid = l_sql.indexOf("?") < index;
        }
        if ((l_sql = l_sql.trim()).startsWith("{") && l_sql.endsWith("}")) {
            l_sql = l_sql.substring(1, l_sql.length() - 1);
        } else {
            isValid = false;
        }
        index = l_sql.indexOf("call");
        if (index == -1 || !isValid) {
            throw new PSQLException("postgresql.call.malformed", new Object[]{l_sql, JDBC_SYNTAX});
        }
        l_sql = l_sql.replace('{', ' ');
        l_sql = l_sql.replace('}', ' ');
        l_sql = l_sql.replace(';', ' ');
        l_sql = (this.isFunction ? "?" : "") + l_sql.substring(index + 4);
        l_sql = "select " + l_sql + " as " + RESULT_COLUMN + ";";
        return l_sql;
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn) {
            throw new PSQLException("postgresql.call.wrongget", new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type});
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException("postgresql.call.noreturntype");
        }
        if (parameterIndex != 1) {
            throw new PSQLException("postgresql.call.noinout");
        }
    }

    public void setUseServerPrepare(boolean flag) throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.3")) {
            if (this.m_useServerPrepare != flag && !flag) {
                this.connection.ExecSQL("DEALLOCATE " + this.m_statementName);
            }
            this.m_statementName = null;
            this.m_useServerPrepare = flag;
        }
    }

    public boolean isUseServerPrepare() {
        return this.m_useServerPrepare;
    }
}

