package edu.udo.cs.miningmart.operator;

/**
 * Interface to be implemented by any class that
 * provides a method for the MiningMart operator
 * <code>AttributeDerivation</code>.
 * 
 * @author Timm Euler
 */
public interface AttrDerivInterface {

	/**
	 * The method expected by the MiningMart operator 'AttributeDerivation'.
	 * 
	 * @param columnNames Names of the columns of the input data set
	 * @param namesOfTargetColumns names of target columns, can be NULL
	 * @param dataset the input data set (columns in the first dimension,
	 * rows in the second dimension)
	 * 
	 * @return a String[] with the values of the newly derived attribute
	 */
    public String[] deriveAttribute(
    		String[] columnNames,
			String[] namesOfTargetColumns,
			String[][] dataset);
}
