/**
 * Example for a class that can be used in MiningMart's 
 * 'AttributeDerivation' operator. The name of the class is given
 * as a parameter to that operator. The class MUST implement
 * the interface <code>edu.udo.cs.miningmart.operator.AttrDerivInterface</code>.
 * Several classes like this one can be packed to a JAR file and added
 * to the MiningMart/lib/ directory, to be available in different steps
 * that use the operator.
 * This example class simply copies the values of the target attribute,
 * but any other way of creating the values of the output attribute
 * can be chosen.
 * 
 * @author euler
 */
public class AttrDerivExample implements edu.udo.cs.miningmart.operator.AttrDerivInterface{
	
	/**
	 * The method expected by the MiningMart operator 'AttributeDerivation'.
	 * 
	 * @param columnNames Names of the columns of the input data set
	 * @param namesOfTargetColumns names of target columns, can be NULL
	 * @param dataset the input data set (columns in the first dimension,
	 * rows in the second dimension)
	 * 
	 * @return a String[] with the values of the newly derived attribute
	 */
    public String[] deriveAttribute(
    		String[] columnNames,
			String[] namesOfTargetColumns,
			String[][] dataset) {
    	
    	// no need to handle null input:
    	if (columnNames == null || dataset == null) 
    		return null;
    	
    	// the target columns can be null as they are optional;
    	// here we expect only one target column:
    	int targetIndex = 0;
    	if (namesOfTargetColumns != null && namesOfTargetColumns.length > 0) {
    		for (int i = 0; i < columnNames.length; i++) {
    			if (columnNames[i].equalsIgnoreCase(namesOfTargetColumns[0])) {
    				targetIndex = i;
    			}
    		}
    	}
    	
    	// this example method simply copies the values of the
    	// target attribute to the new attribute, but any other
    	// way of deriving the new attribute values from the 
    	// input data is possible:
    	String[] targetColumnValues = dataset[targetIndex];
    	String[] ret = new String[targetColumnValues.length];
    	for (int j = 0; j < targetColumnValues.length; j++) {
    		ret[j] = targetColumnValues[j];
    	}
    	
    	// return a String[] with the values for the data set;
    	// it must not have more values than the input data set
    	// has rows:
    	return ret;
    }
}