#!/bin/sh

##############################################################
#                       ATTENTION !!!                        #
# Do not run this script if your M4 tables contain valuable  #
# data. The script deletes all M4 tables!                    #
#                                                            #
# Furthermore, the script installs functions and stored      #
# procedures into the business data schema:                  #
#                                                            #
#                         PL/SQL:                            #
# - procedure dbWindow                                       #
# - procedure EMA                                            #
# - procedure SMA                                            #
# - procedure WMA                                            #
# - procedure SimpleSTSP                                     #
#                                                            #
# Java Classes: package name "miningmart"                    #
#                                                            #
# Please  make sure, that no PL/SQL functions/procedures     #
# or JAVA classes are overwritten in the business data       #
# schema !!                                                  #
##############################################################

# Please edit the following lines before running this script.

# Enter here the username, password and SID for the database
# schema that will hold the M4 tables, that is, the tables 
# that MiningMart uses to store its cases. The SID is the
# name under which your Oracle server listens for SQLPlus
# connections.
M4USER=
M4PASS=
M4SID=

# Enter here the username, password and SID for the database
# schema that contains the actual data you want to analyse
# (called "business data schema" in MiningMart):
BDUSER=
BDPASS=
BDSID=

# Enter here the command which is used to run SQLPlus on your
# system. Often this is simply sqlplus but sometimes you may 
# have to enter the complete path to that command here.
SQL_PLUS=sqlplus

# Enter here the command which is used to load Java stored 
# procedures into Oracle. Often this is simply load_java but
# sometimes you may have to enter the complete path to that
# command here.
LOAD_JAVA=load_java

# Enter a name for a log file here, all log messages produced
# by this script and by Oracle will be stored there:
LOGFILE="installer.log"

# -------------

echo "M4 schema: Installing M4 tables!" | tee "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @CreateM4Tables.sql | tee -a "${LOGFILE}"

echo "M4 schema: Installing M4 operator information!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Operators.sql | tee -a "${LOGFILE}"

echo "M4 schema: Installing a sequence!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Sequence.sql | tee -a "${LOGFILE}"

echo "Business Data Schema: Installing Java Stored Procedures!" | tee -a "${LOGFILE}"
${LOAD_JAVA} -user ${BDUSER}/${BDPASS}@${BDSID} JavaStoredProc/*.java | tee -a "${LOGFILE}"

echo "Business Data Schema: Installing embedding PL/SQL functions/procedures for Java procedures!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Functions.sql | tee -a "${LOGFILE}"

echo "Done. All log messages were written to ${LOGFILE}."
