
--- WARNING: Use this script only when the M4 triggers are installed!

--- This script deletes an entry for a given case (case-Id hardcoded)
--- and then continues to delete "orphan" M4 objects.
--- It does NOT COMMIT its deletions - please do this by hand.

-- Delete the case entry:
delete from case_t where ca_id = XXXXXXX;

-- Delete other conceptual M4 objects:
delete from chain_t where ch_caseid is NULL;
delete from concept_t where con_caid is NULL;
delete from step_t where st_caid is NULL;
delete from stepsequence_t where sts_stid is NULL;
delete from parameter_t where par_stid is NULL;
delete from value_t where v_id not in (select par_objid v_id from parameter_t where par_objtype='V');
delete from mcfeature_t where mcf_conid is NULL;

-- Delete BAs that are not linked to a concept:
delete from baseattrib_t where ba_id not in (select bc_baid ba_id from ba_concept_t); 

-- Delete Relations:
delete from relation_t where rel_toconid is NULL and rel_fromconid is NULL;

-- Delete Keys:
delete from keymember_t where km_pkcolid is NULL and km_fkcolid is NULL;
delete from keyhead_t where kh_pkcsid is NULL and kh_fkcsid is NULL;

-- Delete Columns that are not linked to a BA or a Key:
delete from column_t where col_id not in (select bac_colid col_id from ba_column_t) and col_id not in (select km_pkcolid col_id from keymember_t) and col_id not in (select km_fkcolid col_id from keymember_t);

-- Delete Columnsets that are not linked to a Concept and not used as a cross table in a Relation:
delete from columnset_t where cs_conid is NULL and cs_id not in (select rel_csid cs_id from relation_t);

-- Delete from cross tables and statistics tables:
delete from colstatist1_t where colst1_colid not in (select col_id colst1_colid from column_t);
delete from colstatist2_t where colst2_colid not in (select col_id colst2_colid from column_t);
delete from csstatist_t where csst_csid not in (select cs_id csst_id from columnset_t);
delete from ba_concept_t where bc_baid is NULL OR bc_conid is NULL;
delete from ba_column_t where bac_baid is NULL OR bac_colid is NULL;

-- NO COMMIT - COMMIT BY HAND TO BE SURE!!