/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.Collections;
import java.util.List;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.ReverseFigureEnumerator;
import org.jhotdraw.standard.StandardFigureSelection;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;

public class UndoableAdapter
implements Undoable {
    private List myAffectedFigures;
    private boolean myIsUndoable;
    private boolean myIsRedoable;
    private DrawingView myDrawingView;

    public UndoableAdapter(DrawingView newDrawingView) {
        this.setDrawingView(newDrawingView);
    }

    public boolean undo() {
        return this.isUndoable();
    }

    public boolean redo() {
        return this.isRedoable();
    }

    public boolean isUndoable() {
        return this.myIsUndoable;
    }

    public void setUndoable(boolean newIsUndoable) {
        this.myIsUndoable = newIsUndoable;
    }

    public boolean isRedoable() {
        return this.myIsRedoable;
    }

    public void setRedoable(boolean newIsRedoable) {
        this.myIsRedoable = newIsRedoable;
    }

    public void setAffectedFigures(FigureEnumeration newAffectedFigures) {
        if (newAffectedFigures == null) {
            throw new IllegalArgumentException();
        }
        this.rememberFigures(newAffectedFigures);
    }

    public FigureEnumeration getAffectedFigures() {
        if (this.myAffectedFigures == null) {
            return new FigureEnumerator(Collections.EMPTY_LIST);
        }
        return new FigureEnumerator(CollectionsFactory.current().createList(this.myAffectedFigures));
    }

    public FigureEnumeration getAffectedFiguresReversed() {
        return new ReverseFigureEnumerator(CollectionsFactory.current().createList(this.myAffectedFigures));
    }

    public int getAffectedFiguresCount() {
        return this.myAffectedFigures.size();
    }

    protected void rememberFigures(FigureEnumeration toBeRemembered) {
        this.myAffectedFigures = CollectionsFactory.current().createList();
        while (toBeRemembered.hasNextFigure()) {
            this.myAffectedFigures.add(toBeRemembered.nextFigure());
        }
    }

    public void release() {
        FigureEnumeration fe = this.getAffectedFigures();
        while (fe.hasNextFigure()) {
            fe.nextFigure().release();
        }
        this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
    }

    protected void duplicateAffectedFigures() {
        this.setAffectedFigures(StandardFigureSelection.duplicateFigures(this.getAffectedFigures(), this.getAffectedFiguresCount()));
    }

    public DrawingView getDrawingView() {
        return this.myDrawingView;
    }

    protected void setDrawingView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }
}

