/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.util.VersionControlStrategy;
import org.jhotdraw.util.VersionManagement;
import org.jhotdraw.util.VersionRequester;

public class StandardVersionControlStrategy
implements VersionControlStrategy {
    private VersionRequester myVersionRequester;

    public StandardVersionControlStrategy(VersionRequester newVersionRequester) {
        this.setVersionRequester(newVersionRequester);
    }

    public void assertCompatibleVersion() {
        String[] requiredVersions = this.getVersionRequester().getRequiredVersions();
        if (requiredVersions.length == 0) {
            return;
        }
        int i = 0;
        while (i < requiredVersions.length) {
            if (this.isCompatibleVersion(requiredVersions[i])) {
                return;
            }
            ++i;
        }
        this.handleIncompatibleVersions();
    }

    protected void handleIncompatibleVersions() {
        String[] requiredVersions = this.getVersionRequester().getRequiredVersions();
        StringBuffer expectedVersions = new StringBuffer("[");
        int i = 0;
        while (i < requiredVersions.length - 1) {
            expectedVersions.append(String.valueOf(requiredVersions[i]) + ", ");
            ++i;
        }
        if (requiredVersions.length > 0) {
            expectedVersions.append(requiredVersions[requiredVersions.length - 1]);
        }
        expectedVersions.append("]");
        throw new JHotDrawRuntimeException("Incompatible version of JHotDraw found: " + VersionManagement.getJHotDrawVersion() + " (expected: " + expectedVersions + ")");
    }

    protected boolean isCompatibleVersion(String compareVersionString) {
        return VersionManagement.isCompatibleVersion(compareVersionString);
    }

    private void setVersionRequester(VersionRequester newVersionRequester) {
        this.myVersionRequester = newVersionRequester;
    }

    protected VersionRequester getVersionRequester() {
        return this.myVersionRequester;
    }
}

