/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jhotdraw.util.CollectionsFactory;

public class Iconkit {
    private Map fMap = new Hashtable(53);
    private Set fRegisteredImages = CollectionsFactory.current().createSet();
    private Component fComponent;
    private static final int ID = 123;
    private static Iconkit fgIconkit = null;

    public Iconkit(Component component) {
        this.fComponent = component;
        fgIconkit = this;
    }

    public static Iconkit instance() {
        return fgIconkit;
    }

    public Image loadImageUncachedURL(URL url) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            return toolkit.createImage((ImageProducer)url.getContent());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Image loadImageUncached(String fileName) {
        return this.loadImageUncachedURL(this.getResourceURL(fileName));
    }

    public Image loadImageURL(URL url, boolean waitForLoad) {
        if (this.fMap.containsKey(url)) {
            return (Image)this.fMap.get(url);
        }
        Image image = this.loadImageUncachedURL(url);
        if (image != null) {
            this.fMap.put(url, image);
            if (waitForLoad) {
                this.waitForLoadedImage(image);
            }
        }
        return image;
    }

    public Image loadImage(String fileName, boolean waitForLoad) {
        return this.loadImageURL(this.getResourceURL(fileName), waitForLoad);
    }

    public Image loadImageURL(URL url) {
        return this.loadImageURL(url, false);
    }

    public Image loadImage(String fileName) {
        return this.loadImageURL(this.getResourceURL(fileName), false);
    }

    public Image waitForLoadedImage(Image image) {
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            image = icon.getImage();
        }
        return image;
    }

    private URL getResourceURL(String resourceName) {
        return this.getClass().getResource(resourceName);
    }

    public void registerImageURL(URL url) {
        this.fRegisteredImages.add(url);
    }

    public void registerImage(String fileName) {
        this.registerImageURL(this.getResourceURL(fileName));
    }

    public void loadRegisteredImages(Component component) {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        if (component == null) {
            component = this.fComponent;
        }
        MediaTracker tracker = new MediaTracker(component);
        for (URL url : this.fRegisteredImages) {
            if (this.fMap.containsKey(url)) continue;
            tracker.addImage(this.loadImageURL(url), 123);
        }
        this.fRegisteredImages.clear();
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getImage(String fileName) {
        return this.loadImage(fileName, true);
    }

    public Image registerAndLoadImage(Component component, String fileName) {
        this.registerImage(fileName);
        this.loadRegisteredImages(component);
        return this.loadImage(fileName, true);
    }

    public Image loadImageResource(String fileName) {
        return this.loadImageUncached(fileName);
    }
}

