/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class FloatingTextField {
    private JTextField fEditWidget = new JTextField(20);
    private Container fContainer;

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        container.add((Component)this.fEditWidget, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.fContainer = container;
    }

    public void addActionListener(ActionListener listener) {
        this.fEditWidget.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.fEditWidget.removeActionListener(listener);
    }

    public void setBounds(Rectangle r, String text) {
        this.fEditWidget.setText(text);
        this.fEditWidget.setLocation(r.x, r.y);
        this.fEditWidget.setSize(r.width, r.height);
        this.fEditWidget.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public Dimension getPreferredSize(int cols) {
        this.fEditWidget.setColumns(cols);
        return this.fEditWidget.getPreferredSize();
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditWidget != null) {
            this.fEditWidget.setVisible(false);
            this.fContainer.remove(this.fEditWidget);
            Rectangle bounds = this.fEditWidget.getBounds();
            this.fContainer.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

