/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.framework.JHotDrawRuntimeException;

public abstract class CollectionsFactory {
    private static String JAVA_UTIL_LIST = "java.util.List";
    private static String COLLECTIONS_FACTORY_PACKAGE = "org.jhotdraw.util.collections.jdk";
    private static final CollectionsFactory factory = CollectionsFactory.determineCollectionsFactory();

    public abstract List createList();

    public abstract List createList(Collection var1);

    public abstract List createList(int var1);

    public abstract Map createMap();

    public abstract Map createMap(Map var1);

    public abstract Set createSet();

    public abstract Set createSet(Set var1);

    public static CollectionsFactory current() {
        return factory;
    }

    protected static CollectionsFactory determineCollectionsFactory() {
        String jdkVersion = null;
        jdkVersion = CollectionsFactory.isJDK12() ? "12" : "11";
        return CollectionsFactory.createCollectionsFactory(jdkVersion);
    }

    protected static boolean isJDK12() {
        try {
            Class.forName(JAVA_UTIL_LIST);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected static CollectionsFactory createCollectionsFactory(String jdkVersion) {
        try {
            Class<?> factoryClass = Class.forName(String.valueOf(COLLECTIONS_FACTORY_PACKAGE) + jdkVersion + ".CollectionsFactoryJDK" + jdkVersion);
            return (CollectionsFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JHotDrawRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new JHotDrawRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JHotDrawRuntimeException(e);
        }
    }
}

