/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PrinterGraphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jhotdraw.contrib.AutoscrollHelper;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.contrib.dnd.DNDInterface;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Painter;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.InsertIntoDrawingVisitor;
import org.jhotdraw.standard.ReverseFigureEnumerator;
import org.jhotdraw.standard.SimpleUpdateStrategy;
import org.jhotdraw.standard.StandardFigureSelection;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.UndoableCommand;

public class StandardDrawingView
extends JPanel
implements DrawingView,
DNDInterface,
Autoscroll {
    private transient DrawingEditor fEditor;
    private transient List fSelectionListeners;
    private Drawing fDrawing;
    private transient Rectangle fDamage;
    private transient List fSelection;
    private transient List fSelectionHandles;
    private Point fLastClick;
    private List fBackgrounds;
    private List fForegrounds;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    public static final int MINIMUM_WIDTH = 400;
    public static final int MINIMUM_HEIGHT = 300;
    public static final int SCROLL_INCR = 100;
    public static final int SCROLL_OFFSET = 10;
    private static int counter;
    private int myCounter = counter++;
    private DNDHelper dndh;
    private MouseListener mouseListener;
    private MouseMotionListener motionListener;
    private KeyListener keyListener;
    private boolean myIsReadOnly;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;
    private Point toolTipLocation;
    private ASH ash = new ASH(10);

    public StandardDrawingView(DrawingEditor editor) {
        this(editor, 400, 300);
    }

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        this.setAutoscrolls(true);
        this.fEditor = editor;
        this.setPreferredSize(new Dimension(width, height));
        this.fSelectionListeners = CollectionsFactory.current().createList();
        this.addFigureSelectionListener(this.editor());
        this.setLastClick(new Point(0, 0));
        this.fConstrainer = null;
        this.fSelection = CollectionsFactory.current().createList();
        this.setDisplayUpdate(this.createDisplayUpdate());
        this.setBackground(Color.lightGray);
        this.addMouseListener(this.createMouseListener());
        this.addMouseMotionListener(this.createMouseMotionListener());
        this.addKeyListener(this.createKeyListener());
    }

    protected MouseListener createMouseListener() {
        this.mouseListener = new DrawingViewMouseListener();
        return this.mouseListener;
    }

    protected MouseMotionListener createMouseMotionListener() {
        this.motionListener = new DrawingViewMouseMotionListener();
        return this.motionListener;
    }

    protected KeyListener createKeyListener() {
        this.keyListener = new DrawingViewKeyListener();
        return this.keyListener;
    }

    protected Painter createDisplayUpdate() {
        return new SimpleUpdateStrategy();
    }

    public void setEditor(DrawingEditor editor) {
        this.fEditor = editor;
    }

    public Tool tool() {
        return this.editor().tool();
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void setDrawing(Drawing d) {
        if (this.drawing() != null) {
            this.clearSelection();
            this.drawing().removeDrawingChangeListener(this);
        }
        this.fDrawing = d;
        if (this.drawing() != null) {
            this.drawing().addDrawingChangeListener(this);
        }
        this.checkMinimumSize();
        this.repaint();
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void addAll(Collection figures) {
        FigureEnumerator fe = new FigureEnumerator(figures);
        while (fe.hasNextFigure()) {
            this.add(fe.nextFigure());
        }
    }

    public boolean figureExists(Figure inf, FigureEnumeration fe) {
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (!figure.includes(inf)) continue;
            return true;
        }
        return false;
    }

    public FigureEnumeration insertFigures(FigureEnumeration fe, int dx, int dy, boolean bCheck) {
        if (fe == null) {
            return FigureEnumerator.getEmptyEnumeration();
        }
        List vCF = CollectionsFactory.current().createList(10);
        InsertIntoDrawingVisitor visitor = new InsertIntoDrawingVisitor(this.drawing());
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (figure instanceof ConnectionFigure) {
                vCF.add(figure);
                continue;
            }
            if (figure == null) continue;
            figure.moveBy(dx, dy);
            figure.visit(visitor);
        }
        FigureEnumerator ecf = new FigureEnumerator(vCF);
        while (ecf.hasNextFigure()) {
            ConnectionFigure cf = (ConnectionFigure)ecf.nextFigure();
            Figure sf = cf.startFigure();
            Figure ef = cf.endFigure();
            if (!this.figureExists(sf, this.drawing().figures()) || !this.figureExists(ef, this.drawing().figures()) || bCheck && !cf.canConnect(sf, ef)) continue;
            if (bCheck) {
                Point sp = sf.center();
                Point ep = ef.center();
                Connector fStartConnector = cf.startFigure().connectorAt(ep.x, ep.y);
                Connector fEndConnector = cf.endFigure().connectorAt(sp.x, sp.y);
                if (fEndConnector != null && fStartConnector != null) {
                    cf.connectStart(fStartConnector);
                    cf.connectEnd(fEndConnector);
                    cf.updateConnection();
                }
            }
            cf.visit(visitor);
        }
        this.addToSelectionAll(visitor.getInsertedFigures());
        return visitor.getInsertedFigures();
    }

    public FigureEnumeration getConnectionFigures(Figure inFigure) {
        if (inFigure == null || !inFigure.canConnect()) {
            return null;
        }
        List result = CollectionsFactory.current().createList(5);
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasNextFigure()) {
            ConnectionFigure cf;
            Figure f = figures.nextFigure();
            if (!(f instanceof ConnectionFigure) || this.isFigureSelected(f) || !(cf = (ConnectionFigure)f).startFigure().includes(inFigure) && !cf.endFigure().includes(inFigure)) continue;
            result.add(f);
        }
        return new FigureEnumerator(result);
    }

    public void setDisplayUpdate(Painter updateStrategy) {
        this.fUpdateStrategy = updateStrategy;
    }

    public Painter getDisplayUpdate() {
        return this.fUpdateStrategy;
    }

    public FigureEnumeration selection() {
        return this.selectionZOrdered();
    }

    public FigureEnumeration selectionZOrdered() {
        List result = CollectionsFactory.current().createList(this.selectionCount());
        result.addAll(this.fSelection);
        return new ReverseFigureEnumerator(result);
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public boolean isFigureSelected(Figure checkFigure) {
        return this.fSelection.contains(checkFigure);
    }

    public void addToSelection(Figure figure) {
        if (this.addToSelectionImpl(figure)) {
            this.fireSelectionChanged();
        }
    }

    protected boolean addToSelectionImpl(Figure figure) {
        boolean changed = false;
        if (!this.isFigureSelected(figure) && this.drawing().includes(figure)) {
            this.fSelection.add(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            changed = true;
        }
        return changed;
    }

    public void addToSelectionAll(Collection figures) {
        this.addToSelectionAll(new FigureEnumerator(figures));
    }

    public void addToSelectionAll(FigureEnumeration fe) {
        boolean changed = false;
        while (fe.hasNextFigure()) {
            changed |= this.addToSelectionImpl(fe.nextFigure());
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void removeFromSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.fSelection.remove(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.fireSelectionChanged();
        }
    }

    public void toggleSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.fireSelectionChanged();
    }

    public void clearSelection() {
        if (this.selectionCount() == 0) {
            return;
        }
        FigureEnumeration fe = this.selection();
        while (fe.hasNextFigure()) {
            fe.nextFigure().invalidate();
        }
        this.fSelection = CollectionsFactory.current().createList();
        this.fSelectionHandles = null;
        this.fireSelectionChanged();
    }

    protected HandleEnumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = CollectionsFactory.current().createList();
            FigureEnumeration fe = this.selection();
            while (fe.hasNextFigure()) {
                Figure figure = fe.nextFigure();
                HandleEnumeration kk = figure.handles();
                while (kk.hasNextHandle()) {
                    this.fSelectionHandles.add(kk.nextHandle());
                }
            }
        }
        return new HandleEnumerator(this.fSelectionHandles);
    }

    public FigureSelection getFigureSelection() {
        return new StandardFigureSelection(this.selectionZOrdered(), this.selectionCount());
    }

    public Handle findHandle(int x, int y) {
        HandleEnumeration he = this.selectionHandles();
        while (he.hasNextHandle()) {
            Handle handle = he.nextHandle();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    protected void fireSelectionChanged() {
        if (this.fSelectionListeners != null) {
            int i = 0;
            while (i < this.fSelectionListeners.size()) {
                FigureSelectionListener l = (FigureSelectionListener)this.fSelectionListeners.get(i);
                l.figureSelectionChanged(this);
                ++i;
            }
        }
    }

    protected Rectangle getDamage() {
        return this.fDamage;
    }

    protected void setDamage(Rectangle r) {
        this.fDamage = r;
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    protected void setLastClick(Point newLastClick) {
        this.fLastClick = newLastClick;
    }

    public void setConstrainer(PointConstrainer c) {
        this.fConstrainer = c;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(p);
        }
        return p;
    }

    private void moveSelection(int dx, int dy) {
        FigureEnumeration figures = this.selection();
        while (figures.hasNextFigure()) {
            figures.nextFigure().moveBy(dx, dy);
        }
        this.checkDamage();
    }

    public synchronized void checkDamage() {
        Iterator each = this.drawing().drawingChangeListeners();
        while (each.hasNext()) {
            Object l = each.next();
            if (!(l instanceof DrawingView)) continue;
            ((DrawingView)l).repairDamage();
        }
    }

    public void repairDamage() {
        if (this.getDamage() != null) {
            this.repaint(this.getDamage().x, this.getDamage().y, this.getDamage().width, this.getDamage().height);
            this.setDamage(null);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.getDamage() == null) {
            this.setDamage(r);
        } else {
            Rectangle damagedR = this.getDamage();
            damagedR.add(r);
            this.setDamage(damagedR);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.repairDamage();
    }

    public void drawingTitleChanged(DrawingChangeEvent e) {
    }

    protected void paintComponent(Graphics g) {
        if (this.getDisplayUpdate() != null) {
            this.getDisplayUpdate().draw(g, this);
        }
    }

    public void drawAll(Graphics g) {
        boolean isPrinting = this.isPrinting(g);
        this.drawBackground(g);
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.drawDrawing(g);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void draw(Graphics g, FigureEnumeration fe) {
        boolean isPrinting = this.isPrinting(g);
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.drawing().draw(g, fe);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void drawHandles(Graphics g) {
        HandleEnumeration he = this.selectionHandles();
        while (he.hasNextHandle()) {
            he.nextHandle().draw(g);
        }
    }

    public void drawDrawing(Graphics g) {
        this.drawing().draw(g);
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    protected void drawPainters(Graphics g, List v) {
        int i = 0;
        while (i < v.size()) {
            ((Painter)v.get(i)).draw(g, this);
            ++i;
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = CollectionsFactory.current().createList(3);
        }
        this.fBackgrounds.add(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.remove(painter);
        }
        this.repaint();
    }

    protected List getBackgrounds() {
        return this.fBackgrounds;
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.remove(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = CollectionsFactory.current().createList(3);
        }
        this.fForegrounds.add(painter);
        this.repaint();
    }

    protected List getForegrounds() {
        return this.fForegrounds;
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fSelection = CollectionsFactory.current().createList();
        if (this.drawing() != null) {
            this.drawing().addDrawingChangeListener(this);
        }
        this.fSelectionListeners = CollectionsFactory.current().createList();
    }

    protected void checkMinimumSize() {
        Dimension d = this.getDrawingSize();
        Dimension v = this.getPreferredSize();
        if (v.height < d.height || v.width < d.width) {
            v.height = d.height + 10;
            v.width = d.width + 10;
            this.setPreferredSize(v);
        }
    }

    protected Dimension getDrawingSize() {
        Dimension d = new Dimension(0, 0);
        if (this.drawing() != null) {
            FigureEnumeration fe = this.drawing().figures();
            while (fe.hasNextFigure()) {
                Rectangle r = fe.nextFigure().displayBox();
                d.width = Math.max(d.width, r.x + r.width);
                d.height = Math.max(d.height, r.y + r.height);
            }
        }
        return d;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isInteractive() {
        return true;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void addFigureSelectionListener(FigureSelectionListener fsl) {
        this.fSelectionListeners.add(fsl);
    }

    public void removeFigureSelectionListener(FigureSelectionListener fsl) {
        this.fSelectionListeners.remove(fsl);
    }

    public int getDefaultDNDActions() {
        return 3;
    }

    public void autoscroll(Point p) {
        this.ash.autoscroll(p);
    }

    public Insets getAutoscrollInsets() {
        return this.ash.getAutoscrollInsets();
    }

    public String toString() {
        return "DrawingView Nr: " + this.myCounter;
    }

    protected void handleMouseEventException(Throwable t) {
        JOptionPane.showMessageDialog(this, String.valueOf(t.getClass().getName()) + " - " + t.getMessage(), "Error", 0);
        t.printStackTrace();
    }

    protected DNDHelper createDNDHelper() {
        return new DNDHelper(true, true){

            protected DrawingView view() {
                return StandardDrawingView.this;
            }

            protected DrawingEditor editor() {
                return StandardDrawingView.this.editor();
            }
        };
    }

    protected DNDHelper getDNDHelper() {
        if (this.dndh == null) {
            this.dndh = this.createDNDHelper();
        }
        return this.dndh;
    }

    public DragSourceListener getDragSourceListener() {
        return this.getDNDHelper().getDragSourceListener();
    }

    public void DNDInitialize(DragGestureListener dgl) {
        this.getDNDHelper().initialize(dgl);
    }

    public void DNDDeinitialize() {
        this.getDNDHelper().deinitialize();
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnly(boolean newIsReadOnly) {
        if (newIsReadOnly != this.isReadOnly()) {
            if (newIsReadOnly) {
                this.removeMouseListener(this.mouseListener);
                this.removeMouseMotionListener(this.motionListener);
                this.removeKeyListener(this.keyListener);
            } else {
                this.addMouseListener(this.mouseListener);
                this.addMouseMotionListener(this.motionListener);
                this.addKeyListener(this.keyListener);
            }
            this.myIsReadOnly = newIsReadOnly;
        }
    }

    public void setCursor(Cursor cursor) {
        if (cursor instanceof java.awt.Cursor) {
            super.setCursor((java.awt.Cursor)((Object)cursor));
        }
    }

    public Dimension getMinimumSize() {
        Rectangle r = new Rectangle();
        FigureEnumeration k = this.drawing().figures();
        while (k.hasNextFigure()) {
            r.add(k.nextFigure().displayBox());
        }
        return new Dimension(r.width, r.height);
    }

    public Point getToolTipLocation(MouseEvent event) {
        return this.toolTipLocation;
    }

    public void setToolTipLocation(Point p) {
        this.toolTipLocation = p;
    }

    public void setToolTipFigure(Figure f) {
        Rectangle r = f.displayBox();
        Point p = new Point(r.x, r.y + r.height + 10);
        this.setToolTipLocation(p);
    }

    public void clearToolTip() {
        if (this.getToolTipText() != null) {
            this.setToolTipText(null);
            this.setToolTipLocation(null);
        }
    }

    private boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    class ASH
    extends AutoscrollHelper {
        public ASH(int margin) {
            super(margin);
        }

        public Dimension getSize() {
            return StandardDrawingView.this.getSize();
        }

        public Rectangle getVisibleRect() {
            return StandardDrawingView.this.getVisibleRect();
        }

        public void scrollRectToVisible(Rectangle aRect) {
            StandardDrawingView.this.scrollRectToVisible(aRect);
        }
    }

    public class DrawingViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            try {
                StandardDrawingView.this.requestFocus();
                Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
                StandardDrawingView.this.setLastClick(new Point(e.getX(), e.getY()));
                StandardDrawingView.this.tool().mouseDown(e, p.x, p.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable t) {
                StandardDrawingView.this.handleMouseEventException(t);
            }
        }

        public void mouseReleased(MouseEvent e) {
            try {
                Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
                StandardDrawingView.this.tool().mouseUp(e, p.x, p.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable t) {
                StandardDrawingView.this.handleMouseEventException(t);
            }
        }
    }

    public class DrawingViewMouseMotionListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            try {
                Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
                StandardDrawingView.this.tool().mouseDrag(e, p.x, p.y);
                StandardDrawingView.this.checkDamage();
            }
            catch (Throwable t) {
                StandardDrawingView.this.handleMouseEventException(t);
            }
        }

        public void mouseMoved(MouseEvent e) {
            try {
                StandardDrawingView.this.tool().mouseMove(e, e.getX(), e.getY());
            }
            catch (Throwable t) {
                StandardDrawingView.this.handleMouseEventException(t);
            }
        }
    }

    public class DrawingViewKeyListener
    implements KeyListener {
        private Command deleteCmd = this.createDeleteCommand();

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            int modifiers = e.getModifiers();
            if (modifiers == 0 && (code == 8 || code == 127)) {
                if (this.deleteCmd.isExecutable()) {
                    this.deleteCmd.execute();
                }
            } else if (modifiers == 0 && (code == 40 || code == 38 || code == 39 || code == 37)) {
                this.handleCursorKey(code);
            } else {
                StandardDrawingView.this.tool().keyDown(e, code);
            }
            StandardDrawingView.this.checkDamage();
        }

        protected void handleCursorKey(int key) {
            int dx = 0;
            int dy = 0;
            int stepX = 1;
            int stepY = 1;
            if (StandardDrawingView.this.fConstrainer != null) {
                stepX = StandardDrawingView.this.fConstrainer.getStepX();
                stepY = StandardDrawingView.this.fConstrainer.getStepY();
            }
            switch (key) {
                case 40: {
                    dy = stepY;
                    break;
                }
                case 38: {
                    dy = -stepY;
                    break;
                }
                case 39: {
                    dx = stepX;
                    break;
                }
                case 37: {
                    dx = -stepX;
                }
            }
            StandardDrawingView.this.moveSelection(dx, dy);
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyReleased(KeyEvent event) {
        }

        protected Command createDeleteCommand() {
            return new UndoableCommand(new DeleteCommand("Delete", StandardDrawingView.this.editor()));
        }
    }
}

