/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle fSelectGroup;
    private Color fRubberBandColor;

    public SelectAreaTracker(DrawingEditor newDrawingEditor) {
        this(newDrawingEditor, Color.black);
    }

    public SelectAreaTracker(DrawingEditor newDrawingEditor, Color rubberBandColor) {
        super(newDrawingEditor);
        this.fRubberBandColor = rubberBandColor;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, e.getX(), e.getY());
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), this.getAnchorX(), this.getAnchorY());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.eraseRubberBand();
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.eraseRubberBand();
        this.selectGroup(e.isShiftDown());
        super.mouseUp(e, x, y);
    }

    private void rubberBand(int x1, int y1, int x2, int y2) {
        this.fSelectGroup = new Rectangle(new Point(x1, y1));
        this.fSelectGroup.add(new Point(x2, y2));
        this.drawXORRect(this.fSelectGroup);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fSelectGroup);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = this.view().getGraphics();
        if (g != null) {
            try {
                if (g instanceof Graphics2D) {
                    BasicStroke dashedStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 5.0f);
                    ((Graphics2D)g).setStroke(dashedStroke);
                }
                g.setXORMode(this.view().getBackground());
                g.setColor(this.fRubberBandColor);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void selectGroup(boolean toggle) {
        FigureEnumeration fe = this.drawing().figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            Rectangle r2 = figure.displayBox();
            if (!this.fSelectGroup.contains(r2.x, r2.y) || !this.fSelectGroup.contains(r2.x + r2.width, r2.y + r2.height)) continue;
            if (toggle) {
                this.view().toggleSelection(figure);
                continue;
            }
            this.view().addToSelection(figure);
        }
    }
}

