/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Rectangle;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class ResizeHandle
extends LocatorHandle {
    ResizeHandle(Figure owner, Locator loc) {
        super(owner, loc);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldDisplayBox(this.owner().displayBox());
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle oldDisplayBox = ((UndoActivity)this.getUndoActivity()).getOldDisplayBox();
        if (this.owner().displayBox().equals(oldDisplayBox)) {
            this.setUndoActivity(null);
        }
    }

    protected Undoable createUndoActivity(DrawingView view) {
        return new UndoActivity(view);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Rectangle myOldDisplayBox;

        public UndoActivity(DrawingView newView) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetDisplayBox();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetDisplayBox();
        }

        private boolean resetDisplayBox() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            Figure currentFigure = fe.nextFigure();
            Rectangle figureDisplayBox = currentFigure.displayBox();
            currentFigure.displayBox(this.getOldDisplayBox());
            this.setOldDisplayBox(figureDisplayBox);
            return true;
        }

        protected void setOldDisplayBox(Rectangle newOldDisplayBox) {
            this.myOldDisplayBox = newOldDisplayBox;
        }

        public Rectangle getOldDisplayBox() {
            return this.myOldDisplayBox;
        }
    }
}

