/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.AbstractLocator;

public class PeripheralLocator
extends AbstractLocator {
    private static int CORNERSPACE = 1;
    private Figure fOwner;
    private int fPPS;
    private int fIndex;

    private PeripheralLocator() {
    }

    public PeripheralLocator(int pointsPerSide, int index) {
        this.fPPS = pointsPerSide;
        this.fIndex = index;
        if (index >= pointsPerSide * 4) {
            throw new IllegalArgumentException("Index must be within the range of points starting with index = 0.");
        }
    }

    public Point locate(Figure parm1) {
        Rectangle r = parm1.displayBox();
        float hSpacing = (float)r.width / (float)(this.fPPS + 1);
        float vSpacing = (float)r.height / (float)(this.fPPS + 1);
        int x = 0;
        int y = 0;
        if (this.fIndex < this.fPPS) {
            x = Math.round(((float)this.fIndex + 1.0f) * hSpacing);
            y = 0;
        } else if (this.fIndex < this.fPPS * 2) {
            x = Math.round((float)(this.fPPS + 1) * hSpacing);
            y = Math.round((float)(this.fIndex + 1 - this.fPPS) * vSpacing);
        } else if (this.fIndex < this.fPPS * 3) {
            x = Math.round((float)(this.fPPS + 1 - (this.fIndex + 1 - this.fPPS * 2)) * hSpacing);
            y = Math.round((float)(this.fPPS + 1) * vSpacing);
        } else {
            x = 0;
            y = Math.round((float)(this.fPPS + 1 - (this.fIndex + 1 - this.fPPS * 3)) * vSpacing);
        }
        return new Point(x += r.x, y += r.y);
    }
}

