/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.io.IOException;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractLocator;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class OffsetLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2679950024611847621L;
    private int offsetLocatorSerializedDataVersion = 1;
    private Locator fBase = null;
    protected int fOffsetX = 0;
    protected int fOffsetY = 0;

    public OffsetLocator() {
    }

    public OffsetLocator(Locator base) {
        this();
        this.fBase = base;
    }

    public OffsetLocator(Locator base, int offsetX, int offsetY) {
        this(base);
        this.fOffsetX = offsetX;
        this.fOffsetY = offsetY;
    }

    public Point locate(Figure owner) {
        Point p = this.fBase.locate(owner);
        p.x += this.fOffsetX;
        p.y += this.fOffsetY;
        return p;
    }

    public void moveBy(int dx, int dy) {
        this.fOffsetX += dx;
        this.fOffsetY += dy;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOffsetX);
        dw.writeInt(this.fOffsetY);
        dw.writeStorable(this.fBase);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOffsetX = dr.readInt();
        this.fOffsetY = dr.readInt();
        this.fBase = (Locator)dr.readStorable();
    }
}

