/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.LocatorConnector;
import org.jhotdraw.standard.OffsetLocator;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.Geom;

public class OffsetConnector
extends LocatorConnector {
    public static OffsetConnector trackingConnector1 = new OffsetConnector();
    public static OffsetConnector trackingConnector2 = new OffsetConnector();
    private static Point trackingPoint = new Point();
    private static OffsetConnector firstConnector;
    private static OffsetConnector lastConnector;
    private static DrawingView view;
    private transient Rectangle fOwnerBox;

    public void reset(DrawingView drawingView) {
        if (this == trackingConnector1) {
            view = drawingView;
            firstConnector = null;
            lastConnector = null;
            OffsetConnector.trackingConnector1.fOwner = null;
            OffsetConnector.trackingConnector2.fOwner = null;
        }
    }

    public static OffsetConnector trackConnector(Figure owner, int x, int y) {
        OffsetConnector trackingConnector = trackingConnector1;
        if (firstConnector != null && owner != trackingConnector1.owner()) {
            trackingConnector = trackingConnector2;
        }
        if (trackingConnector.fOwner != owner) {
            trackingConnector.fOwner = owner;
            trackingConnector.fOwnerBox = owner.displayBox();
        }
        if (firstConnector == null) {
            firstConnector = trackingConnector;
        }
        lastConnector = trackingConnector;
        return trackingConnector.calculateFigureConstrainedOffsets(x, y);
    }

    public OffsetConnector() {
        OffsetLocator loc = new OffsetLocator(RelativeLocator.northWest());
        this.myLocator = loc;
        this.fOwner = null;
        this.fOwnerBox = new Rectangle();
    }

    private OffsetConnector(Figure owner, int offsetX, int offsetY) {
        super(owner, null);
        OffsetLocator loc = new OffsetLocator(RelativeLocator.northWest(), offsetX, offsetY);
        this.myLocator = loc;
        this.fOwnerBox = owner.displayBox();
    }

    public Connector finalizeConnector(boolean start) {
        if (this != trackingConnector1 && this != trackingConnector2) {
            return this;
        }
        OffsetLocator l = (OffsetLocator)this.myLocator;
        OffsetConnector o = new OffsetConnector(this.owner(), l.fOffsetX, l.fOffsetY);
        if (this == trackingConnector2) {
            int p1X = trackingConnector1.locateX();
            int p1Y = trackingConnector1.locateY();
            int p2X = this.locateX();
            int p2Y = this.locateY();
            if (Math.abs(p1X - p2X) <= 8) {
                p2X = p1X;
            }
            if (Math.abs(p1Y - p2Y) <= 8) {
                p2Y = p1Y;
            }
            l = (OffsetLocator)o.myLocator;
            l.fOffsetX = Geom.range(0, this.fOwnerBox.width, p2X - this.fOwnerBox.x);
            l.fOffsetY = Geom.range(0, this.fOwnerBox.height, p2Y - this.fOwnerBox.y);
        }
        return o;
    }

    public Point connectorMovedTo(int x, int y) {
        this.calculateFigureConstrainedOffsets(x, y);
        int px = this.locateX();
        int py = this.locateY();
        OffsetLocator l = (OffsetLocator)this.myLocator;
        if (this.owner() instanceof RectangleFigure) {
            if (Math.abs(py - y) <= 3 && (l.fOffsetX == 0 || l.fOffsetX == this.fOwnerBox.width)) {
                l.fOffsetY = Geom.range(0, this.fOwnerBox.height, y - this.fOwnerBox.y);
            }
            if (Math.abs(px - x) <= 3 && (l.fOffsetY == 0 || l.fOffsetY == this.fOwnerBox.height)) {
                l.fOffsetX = Geom.range(0, this.fOwnerBox.width, x - this.fOwnerBox.x);
            }
        }
        return new Point(this.locateX(), this.locateY());
    }

    protected Point findPoint(ConnectionFigure connection) {
        Rectangle r = this.owner().displayBox();
        if (this.fOwnerBox.width == 0 && this.fOwnerBox.height == 0) {
            this.fOwnerBox = r;
        }
        OffsetLocator l = (OffsetLocator)this.myLocator;
        Point p1 = this.locate(connection);
        if (this.fOwnerBox.width == r.width && this.fOwnerBox.height == r.height) {
            this.fOwnerBox = r;
            return p1;
        }
        if (this.owner() instanceof EllipseFigure) {
            this.calculateFigureConstrainedOffsets(p1.x, p1.y);
            this.fOwnerBox = r;
            return p1;
        }
        p1.x = this.fOwnerBox.x + l.fOffsetX;
        p1.y = this.fOwnerBox.y + l.fOffsetY;
        if (l.fOffsetX == 0) {
            p1.x = r.x;
        } else if (l.fOffsetX == this.fOwnerBox.width) {
            p1.x = r.x + r.width;
        }
        if (l.fOffsetY == 0) {
            p1.y = r.y;
        } else if (l.fOffsetY == this.fOwnerBox.height) {
            p1.y = r.y + r.height;
        }
        if (view != null && view.getConstrainer() != null) {
            p1 = view.getConstrainer().constrainPoint(p1);
        }
        l.fOffsetX = Geom.range(0, r.width, p1.x - r.x);
        l.fOffsetY = Geom.range(0, r.height, p1.y - r.y);
        this.fOwnerBox = r;
        return p1;
    }

    protected Point locate(ConnectionFigure connection) {
        return this.myLocator.locate(this.owner());
    }

    public int locateX() {
        OffsetLocator l = (OffsetLocator)this.myLocator;
        return this.fOwnerBox.x + l.fOffsetX;
    }

    public int locateY() {
        OffsetLocator l = (OffsetLocator)this.myLocator;
        return this.fOwnerBox.y + l.fOffsetY;
    }

    public OffsetConnector calculateFigureConstrainedOffsets(int x, int y) {
        trackingPoint = this.calculateFigureConstrainedTrackingPoint(x, y);
        OffsetLocator l = (OffsetLocator)this.myLocator;
        l.fOffsetX = OffsetConnector.trackingPoint.x - this.fOwnerBox.x;
        l.fOffsetY = OffsetConnector.trackingPoint.y - this.fOwnerBox.y;
        return this;
    }

    protected Point calculateFigureConstrainedTrackingPoint(int x, int y) {
        OffsetConnector.trackingPoint.x = x;
        OffsetConnector.trackingPoint.y = y;
        if (view != null && view.getConstrainer() != null) {
            trackingPoint = view.getConstrainer().constrainPoint(trackingPoint);
        }
        trackingPoint = !(this.owner() instanceof EllipseFigure) ? Geom.angleToPoint(this.fOwnerBox, Geom.pointToAngle(this.fOwnerBox, trackingPoint)) : Geom.ovalAngleToPoint(this.fOwnerBox, Geom.pointToAngle(this.fOwnerBox, trackingPoint));
        return trackingPoint;
    }
}

