/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Set;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;

public class InsertIntoDrawingVisitor
implements FigureVisitor {
    private Set myInsertedFigures = CollectionsFactory.current().createSet();
    private Drawing myDrawing;

    public InsertIntoDrawingVisitor(Drawing newDrawing) {
        this.setDrawing(newDrawing);
    }

    private void setDrawing(Drawing newDrawing) {
        this.myDrawing = newDrawing;
    }

    protected Drawing getDrawing() {
        return this.myDrawing;
    }

    public void visitFigure(Figure hostFigure) {
        if (!this.myInsertedFigures.contains(hostFigure) && !this.getDrawing().includes(hostFigure)) {
            Figure addedFigure = this.getDrawing().add(hostFigure);
            this.myInsertedFigures.add(addedFigure);
        }
    }

    public void visitHandle(Handle hostHandle) {
    }

    public void visitFigureChangeListener(FigureChangeListener hostFigureChangeListener) {
    }

    public FigureEnumeration getInsertedFigures() {
        return new FigureEnumerator(this.myInsertedFigures);
    }
}

