/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Painter;

public class FastBufferedUpdateStrategy
implements Painter {
    private BufferedImage _doubleBufferedImage;
    private BufferedImage _scratchPadBufferedImage;
    private int _nImageWidth = 0;
    private int _nImageHeight = 0;
    private boolean _bRedrawAll = true;

    public void draw(Graphics g, DrawingView view) {
        this._checkCaches(view);
        if (this._bRedrawAll) {
            Graphics imageGraphics = this._doubleBufferedImage.getGraphics();
            view.drawAll(imageGraphics);
        } else {
            Rectangle viewClipRectangle = g.getClipBounds();
            int nX1 = viewClipRectangle.x;
            int nY1 = viewClipRectangle.y;
            int nX2 = viewClipRectangle.x + viewClipRectangle.width;
            int nY2 = viewClipRectangle.y + viewClipRectangle.height;
            if (nX1 < 0) {
                nX1 = 0;
            }
            if (nY1 < 0) {
                nY1 = 0;
            }
            if (nX2 < 0) {
                nX2 = 0;
            }
            if (nY2 < 0) {
                nY2 = 0;
            }
            Rectangle viewClipRectangle2 = new Rectangle(nX1, nY1, nX2 - nX1, nY2 - nY1);
            Drawing theDrawing = view.drawing();
            FigureEnumeration fe = theDrawing.figures(viewClipRectangle2);
            Graphics imageGraphics = this._scratchPadBufferedImage.getGraphics();
            imageGraphics.setColor(view.getBackground());
            imageGraphics.fillRect(nX1, nY1, nX2 - nX1, nY2 - nY1);
            view.draw(imageGraphics, fe);
            Graphics dbGraphics = this._doubleBufferedImage.getGraphics();
            dbGraphics.drawImage(this._scratchPadBufferedImage, nX1, nY1, nX2, nY2, nX1, nY1, nX2, nY2, view);
        }
        g.drawImage(this._doubleBufferedImage, 0, 0, view);
        this._bRedrawAll = false;
    }

    private void _checkCaches(DrawingView view) {
        Dimension d = view.getSize();
        if (this._doubleBufferedImage == null || this._nImageWidth != d.width || this._nImageHeight != d.height) {
            this._doubleBufferedImage = new BufferedImage(d.width, d.height, 1);
            this._bRedrawAll = true;
        }
        if (this._scratchPadBufferedImage == null || this._nImageWidth != d.width || this._nImageHeight != d.height) {
            this._scratchPadBufferedImage = new BufferedImage(d.width, d.height, 1);
            Graphics imageGraphics = this._scratchPadBufferedImage.getGraphics();
            view.drawBackground(imageGraphics);
            this._bRedrawAll = true;
        }
        this._nImageWidth = d.width;
        this._nImageHeight = d.height;
    }
}

