/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.OffsetConnector;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class ConnectionTool
extends AbstractTool {
    private Connector myStartConnector;
    private Connector myEndConnector;
    private Connector myTargetConnector;
    private Figure myTarget;
    private ConnectionFigure myConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection;
    private Figure myAddedFigure;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor newDrawingEditor, ConnectionFigure newPrototype) {
        super(newDrawingEditor);
        this.fPrototype = newPrototype;
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        int ex = e.getX();
        int ey = e.getY();
        OffsetConnector.trackingConnector1.reset(this.getActiveView());
        ConnectionFigure connection = this.findConnection(ex, ey, this.drawing());
        if (connection != null) {
            if (!connection.joinSegments(ex, ey)) {
                this.fSplitPoint = connection.splitSegment(ex, ey);
                this.fEditedConnection = connection;
            } else {
                this.fEditedConnection = null;
            }
        } else {
            this.setTargetFigure(this.findConnectionStart(ex, ey, this.drawing()));
            if (this.getTargetFigure() != null) {
                this.setStartConnector(this.findConnector(ex, ey, this.getTargetFigure()));
                if (this.getStartConnector() != null) {
                    this.setConnection(this.createConnection());
                    this.getConnection().startPoint(ex, ey);
                    this.getConnection().endPoint(ex, ey);
                    this.setAddedFigure(this.view().add(this.getConnection()));
                }
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        Point p = new Point(e.getX(), e.getY());
        if (this.getConnection() != null) {
            this.trackConnectors(e, x, y);
            if (this.getTargetConnector() != null) {
                p = Geom.center(this.getTargetConnector().displayBox());
            }
            this.getConnection().endPoint(p.x, p.y);
        } else if (this.fEditedConnection != null) {
            Point pp = new Point(x, y);
            this.fEditedConnection.setPointAt(pp, this.fSplitPoint);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        Figure c = null;
        if (this.getStartConnector() != null) {
            c = this.findTarget(e.getX(), e.getY(), this.drawing());
        }
        if (c != null) {
            this.setEndConnector(this.findConnector(e.getX(), e.getY(), c));
            if (this.getEndConnector() != null) {
                this.getConnection().connectStart(this.getStartConnector());
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().updateConnection();
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
            }
        } else if (this.getConnection() != null) {
            this.view().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setAddedFigure(null);
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        return this.findConnectableFigure(x, y, drawing);
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        boolean includesStart;
        Figure target = this.findConnectableFigure(x, y, drawing);
        Figure start = this.getStartConnector().owner();
        boolean bl = includesStart = target != null && target.includes(start);
        if (this.myStartConnector == OffsetConnector.trackingConnector1 || this.myStartConnector == OffsetConnector.trackingConnector2) {
            includesStart = false;
        }
        if (target != null && this.getConnection() != null && target.canConnect() && !includesStart && this.getConnection().canConnect(start, target)) {
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration fe = drawing.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.myConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected void trackConnectors(MouseEvent e, int x, int y) {
        Figure c = null;
        c = this.getStartConnector() == null ? this.findSource(x, y, this.getActiveDrawing()) : this.findTarget(x, y, this.getActiveDrawing());
        if (c != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(c);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(e.getX(), e.getY(), c);
        }
        if (cc != this.getTargetConnector()) {
            this.setTargetConnector(cc);
        }
        this.getActiveView().checkDamage();
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration fe = drawing.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected void setStartConnector(Connector newStartConnector) {
        this.myStartConnector = newStartConnector;
    }

    protected Connector getStartConnector() {
        return this.myStartConnector;
    }

    protected void setEndConnector(Connector newEndConnector) {
        this.myEndConnector = newEndConnector;
    }

    protected Connector getEndConnector() {
        return this.myEndConnector;
    }

    protected void setTargetConnector(Connector newTargetConnector) {
        this.myTargetConnector = newTargetConnector;
    }

    protected Connector getTargetConnector() {
        return this.myTargetConnector;
    }

    protected void setTargetFigure(Figure newTarget) {
        this.myTarget = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.myTarget;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    protected void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getConnection());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private ConnectionFigure myConnection;
        private Connector myStartConnector;
        private Connector myEndConnector;

        public UndoActivity(DrawingView newDrawingView, ConnectionFigure newConnection) {
            super(newDrawingView);
            this.setConnection(newConnection);
            this.myStartConnector = this.getConnection().getStartConnector();
            this.myEndConnector = this.getConnection().getEndConnector();
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getConnection().disconnectStart();
            this.getConnection().disconnectEnd();
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                this.getDrawingView().drawing().orphan(fe.nextFigure());
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getConnection().connectStart(this.myStartConnector);
            this.getConnection().connectEnd(this.myEndConnector);
            this.getConnection().updateConnection();
            this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false);
            return true;
        }

        protected void setConnection(ConnectionFigure newConnection) {
            this.myConnection = newConnection;
        }

        protected ConnectionFigure getConnection() {
            return this.myConnection;
        }
    }
}

