/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.OrderedFigureElement;
import org.jhotdraw.standard.QuadTree;
import org.jhotdraw.standard.ReverseFigureEnumerator;
import org.jhotdraw.util.Bounds;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    protected List fFigures = CollectionsFactory.current().createList();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;
    private transient QuadTree _theQuadTree;
    protected int _nLowestZ = 0;
    protected int _nHighestZ = 0;

    protected CompositeFigure() {
    }

    public Figure add(Figure figure) {
        if (!this.containsFigure(figure)) {
            figure.setZValue(++this._nHighestZ);
            this.fFigures.add(figure);
            figure.addToContainer(this);
            this._addToQuadTree(figure);
        }
        return figure;
    }

    public void addAll(List newFigures) {
        this.addAll(new FigureEnumerator(newFigures));
    }

    public void addAll(FigureEnumeration fe) {
        while (fe.hasNextFigure()) {
            this.add(fe.nextFigure());
        }
    }

    public Figure remove(Figure figure) {
        Figure orphanedFigure = this.orphan(figure);
        if (orphanedFigure != null) {
            orphanedFigure.release();
        }
        return orphanedFigure;
    }

    public void removeAll(List figures) {
        this.removeAll(new FigureEnumerator(figures));
    }

    public void removeAll(FigureEnumeration fe) {
        while (fe.hasNextFigure()) {
            this.remove(fe.nextFigure());
        }
    }

    public void removeAll() {
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            figure.removeFromContainer(this);
        }
        this.fFigures.clear();
        this._clearQuadTree();
        this._nLowestZ = 0;
        this._nHighestZ = 0;
    }

    public synchronized Figure orphan(Figure figure) {
        figure.removeFromContainer(this);
        this.fFigures.remove(figure);
        this._removeFromQuadTree(figure);
        return figure;
    }

    public void orphanAll(List newFigures) {
        this.orphanAll(new FigureEnumerator(newFigures));
    }

    public void orphanAll(FigureEnumeration fe) {
        while (fe.hasNextFigure()) {
            this.orphan(fe.nextFigure());
        }
    }

    public synchronized Figure replace(Figure figure, Figure replacement) {
        int index = this.fFigures.indexOf(figure);
        if (index != -1) {
            replacement.setZValue(figure.getZValue());
            replacement.addToContainer(this);
            figure.removeFromContainer(this);
            this.fFigures.set(index, replacement);
            figure.changed();
            replacement.changed();
        }
        return replacement;
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.containsFigure(figure)) {
            this.fFigures.remove(figure);
            this.fFigures.add(0, figure);
            --this._nLowestZ;
            figure.setZValue(this._nLowestZ);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.containsFigure(figure)) {
            this.fFigures.remove(figure);
            this.fFigures.add(figure);
            ++this._nHighestZ;
            figure.setZValue(this._nHighestZ);
            figure.changed();
        }
    }

    public void sendToLayer(Figure figure, int layerNr) {
        if (this.containsFigure(figure)) {
            if (layerNr >= this.fFigures.size()) {
                layerNr = this.fFigures.size() - 1;
            }
            Figure layerFigure = this.getFigureFromLayer(layerNr);
            int layerFigureZValue = layerFigure.getZValue();
            int figureLayer = this.getLayer(figure);
            if (figureLayer < layerNr) {
                this.assignFiguresToPredecessorZValue(figureLayer + 1, layerNr);
            } else if (figureLayer > layerNr) {
                this.assignFiguresToSuccessorZValue(layerNr, figureLayer - 1);
            }
            this.fFigures.remove(figure);
            this.fFigures.add(layerNr, figure);
            figure.setZValue(layerFigureZValue);
            figure.changed();
        }
    }

    private void assignFiguresToPredecessorZValue(int lowerBound, int upperBound) {
        if (upperBound >= this.fFigures.size()) {
            upperBound = this.fFigures.size() - 1;
        }
        int i = upperBound;
        while (i >= lowerBound) {
            Figure currentFigure = (Figure)this.fFigures.get(i);
            Figure predecessorFigure = (Figure)this.fFigures.get(i - 1);
            currentFigure.setZValue(predecessorFigure.getZValue());
            --i;
        }
    }

    private void assignFiguresToSuccessorZValue(int lowerBound, int upperBound) {
        if (upperBound >= this.fFigures.size()) {
            upperBound = this.fFigures.size() - 1;
        }
        int i = upperBound;
        while (i >= lowerBound) {
            Figure currentFigure = (Figure)this.fFigures.get(i);
            Figure successorFigure = (Figure)this.fFigures.get(i + 1);
            currentFigure.setZValue(successorFigure.getZValue());
            --i;
        }
    }

    public int getLayer(Figure figure) {
        if (!this.containsFigure(figure)) {
            return -1;
        }
        return this.fFigures.indexOf(figure);
    }

    public Figure getFigureFromLayer(int layerNr) {
        if (layerNr >= 0 && layerNr < this.fFigures.size()) {
            return (Figure)this.fFigures.get(layerNr);
        }
        return null;
    }

    public void draw(Graphics g) {
        this.draw(g, this.figures());
    }

    public void draw(Graphics g, FigureEnumeration fe) {
        while (fe.hasNextFigure()) {
            fe.nextFigure().draw(g);
        }
    }

    public Figure figureAt(int i) {
        return (Figure)this.fFigures.get(i);
    }

    public FigureEnumeration figures() {
        return new FigureEnumerator(CollectionsFactory.current().createList(this.fFigures));
    }

    public FigureEnumeration figures(Rectangle viewRectangle) {
        if (this._theQuadTree != null) {
            FigureEnumeration fe = this._theQuadTree.getAllWithin(new Bounds(viewRectangle).asRectangle2D());
            List l2 = CollectionsFactory.current().createList();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                l2.add(new OrderedFigureElement(f, f.getZValue()));
            }
            Collections.sort(l2);
            List l3 = CollectionsFactory.current().createList();
            for (OrderedFigureElement ofe : l2) {
                l3.add(ofe.getFigure());
            }
            return new FigureEnumerator(l3);
        }
        return this.figures();
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public boolean containsFigure(Figure checkFigure) {
        return this.fFigures.contains(checkFigure);
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(CollectionsFactory.current().createList(this.fFigures));
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r) {
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigure(x, y);
        }
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (!figure.containsPoint(x, y) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r, Figure without) {
        if (without == null) {
            return this.findFigure(r);
        }
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInside(int x, int y) {
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigureInside(x, y);
        }
        FigureEnumeration fe = this.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure found;
            Figure figure = fe.nextFigure();
            if (figure == without || (found = figure.findFigureInside(x, y)) == null || figure.includes(without)) continue;
            return found;
        }
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure f = fe.nextFigure();
            if (!f.includes(figure)) continue;
            return true;
        }
        return false;
    }

    protected void basicMoveBy(int x, int y) {
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            fe.nextFigure().moveBy(x, y);
        }
    }

    public void release() {
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            figure.release();
        }
        super.release();
    }

    public void figureInvalidated(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(e);
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(e);
        }
    }

    public void figureChanged(FigureChangeEvent e) {
        this._removeFromQuadTree(e.getFigure());
        this._addToQuadTree(e.getFigure());
    }

    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRemoved(e);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.figureCount());
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            dw.writeStorable(fe.nextFigure());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fFigures = CollectionsFactory.current().createList(size);
        int i = 0;
        while (i < size) {
            this.add((Figure)dr.readStorable());
            ++i;
        }
        this.init(this.displayBox());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            figure.addToContainer(this);
        }
        this.init(new Rectangle(0, 0));
    }

    public void init(Rectangle viewRectangle) {
        this._theQuadTree = new QuadTree(new Bounds(viewRectangle).asRectangle2D());
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            this._addToQuadTree(fe.nextFigure());
        }
    }

    private void _addToQuadTree(Figure f) {
        if (this._theQuadTree != null) {
            Rectangle r = f.displayBox();
            if (r.height == 0) {
                r.grow(0, 1);
            }
            if (r.width == 0) {
                r.grow(1, 0);
            }
            this._theQuadTree.add(f, new Bounds(r).asRectangle2D());
        }
    }

    private void _removeFromQuadTree(Figure f) {
        if (this._theQuadTree != null) {
            this._theQuadTree.remove(f);
        }
    }

    private void _clearQuadTree() {
        if (this._theQuadTree != null) {
            this._theQuadTree.clear();
        }
    }
}

