/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ChangeConnectionHandle;
import org.jhotdraw.util.Undoable;

public class ChangeConnectionStartHandle
extends ChangeConnectionHandle {
    public ChangeConnectionStartHandle(ConnectionFigure owner) {
        super(owner);
    }

    protected Connector target() {
        return this.getConnection().getStartConnector();
    }

    protected void disconnect() {
        this.getConnection().disconnectStart();
    }

    protected void connect(Connector c) {
        this.getConnection().connectStart(c);
    }

    protected void setPoint(int x, int y) {
        this.getConnection().startPoint(x, y);
    }

    public Point locate() {
        return this.getConnection().startPoint();
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        return new UndoActivity(newView);
    }

    protected boolean canConnectTo(Figure figure) {
        return this.getConnection().canConnect(figure, this.source().owner());
    }

    public static class UndoActivity
    extends ChangeConnectionHandle.UndoActivity {
        public UndoActivity(DrawingView newView) {
            super(newView);
        }

        protected Connector replaceConnector(ConnectionFigure connection) {
            Connector tempStartConnector = connection.getStartConnector();
            connection.connectStart(this.getOldConnector());
            return tempStartConnector;
        }
    }
}

