/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.ChopBoxConnector;
import org.jhotdraw.standard.FigureChangeEventMulticaster;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AbstractFigure
implements Figure {
    private transient FigureChangeListener fListener;
    private List myDependendFigures = CollectionsFactory.current().createList();
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    private int _nZ;

    protected AbstractFigure() {
    }

    public void moveBy(int dx, int dy) {
        this.willChange();
        this.basicMoveBy(dx, dy);
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    public void displayBox(Point origin, Point corner) {
        this.willChange();
        this.basicDisplayBox(origin, corner);
        this.changed();
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    public abstract Rectangle displayBox();

    public abstract HandleEnumeration handles();

    public FigureEnumeration figures() {
        return FigureEnumerator.getEmptyEnumeration();
    }

    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public Figure findFigureInside(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    public void displayBox(Rectangle r) {
        this.displayBox(new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
    }

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public FigureEnumeration decompose() {
        List figures = CollectionsFactory.current().createList(1);
        figures.add(this);
        return new FigureEnumerator(figures);
    }

    public void addToContainer(FigureChangeListener c) {
        this.addFigureChangeListener(c);
        this.invalidate();
    }

    public void removeFromContainer(FigureChangeListener c) {
        this.invalidate();
        this.removeFigureChangeListener(c);
    }

    public synchronized void addFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.add(this.listener(), l);
    }

    public synchronized void removeFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.remove(this.listener(), l);
    }

    public synchronized FigureChangeListener listener() {
        return this.fListener;
    }

    public void release() {
        if (this.listener() != null) {
            this.listener().figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void invalidate() {
        if (this.listener() != null) {
            Rectangle r = this.invalidateRectangle(this.displayBox());
            this.listener().figureInvalidated(new FigureChangeEvent(this, r));
        }
    }

    protected Rectangle invalidateRectangle(Rectangle r) {
        r.grow(8, 8);
        return r;
    }

    public void willChange() {
        this.invalidate();
    }

    public void changed() {
        this.invalidate();
        if (this.listener() != null) {
            this.listener().figureChanged(new FigureChangeEvent(this));
        }
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public boolean canConnect() {
        return true;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean isVisible, ConnectionFigure connector) {
    }

    public Locator connectedTextLocator(Figure text) {
        return RelativeLocator.center();
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        return null;
    }

    public void setAttribute(String name, Object value) {
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
    }

    public Object clone() {
        Object clone = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeObject(this);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Class not found: " + e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        try {
            ObjectInputStream reader = new ObjectInputStream(input);
            clone = reader.readObject();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: " + e);
        }
        return clone;
    }

    public void write(StorableOutput dw) {
    }

    public void read(StorableInput dr) throws IOException {
    }

    public int getZValue() {
        return this._nZ;
    }

    public void setZValue(int z) {
        this._nZ = z;
    }

    public void visit(FigureVisitor visitor) {
        FigureEnumeration fe = this.getDependendFigures();
        visitor.visitFigure(this);
        FigureEnumeration visitFigures = this.figures();
        while (visitFigures.hasNextFigure()) {
            visitFigures.nextFigure().visit(visitor);
        }
        HandleEnumeration visitHandles = this.handles();
        while (visitHandles.hasNextHandle()) {
            visitor.visitHandle(visitHandles.nextHandle());
        }
        while (fe.hasNextFigure()) {
            fe.nextFigure().visit(visitor);
        }
    }

    public synchronized FigureEnumeration getDependendFigures() {
        return new FigureEnumerator(this.myDependendFigures);
    }

    public synchronized void addDependendFigure(Figure newDependendFigure) {
        this.myDependendFigures.add(newDependendFigure);
    }

    public synchronized void removeDependendFigure(Figure oldDependendFigure) {
        this.myDependendFigures.remove(oldDependendFigure);
    }

    public TextHolder getTextHolder() {
        return null;
    }

    public Figure getDecoratedFigure() {
        return this;
    }
}

