/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.Color;
import java.util.List;
import org.jhotdraw.figures.ArrowTip;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.samples.pert.PertFigure;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;

public class PertDependency
extends LineConnection {
    private static final long serialVersionUID = -7959500008698525009L;
    private int pertDependencySerializedDataVersion = 1;

    public PertDependency() {
        this.setEndDecoration(new ArrowTip());
        this.setStartDecoration(null);
    }

    public void handleConnect(Figure start, Figure end) {
        PertFigure source = (PertFigure)start;
        PertFigure target = (PertFigure)end;
        if (source.hasCycle(target)) {
            this.setAttribute(FigureAttributeConstant.FRAME_COLOR, (Object)Color.red);
        } else {
            target.addPreTask(source);
            source.addPostTask(target);
            source.notifyPostTasks();
        }
    }

    public void handleDisconnect(Figure start, Figure end) {
        PertFigure source = (PertFigure)start;
        PertFigure target = (PertFigure)end;
        if (target != null) {
            target.removePreTask(source);
            target.updateDurations();
        }
        if (source != null) {
            source.removePostTask(target);
        }
    }

    public boolean canConnect(Figure start, Figure end) {
        return start instanceof PertFigure && end instanceof PertFigure;
    }

    public HandleEnumeration handles() {
        List handles = super.handles().toList();
        handles.set(0, new NullHandle(this, PolyLineFigure.locator(0)));
        return new HandleEnumerator(handles);
    }
}

