/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.ConnectionHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.LocatorConnector;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;

public class NodeFigure
extends TextFigure {
    private static final int BORDER = 6;
    private List fConnectors;
    private boolean fConnectorsVisible;

    public NodeFigure() {
        this.initialize();
        this.fConnectors = null;
    }

    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        int d = 6;
        box.grow(d, d);
        return box;
    }

    public boolean containsPoint(int x, int y) {
        if (this.fConnectorsVisible) {
            Rectangle r = this.displayBox();
            int d = 4;
            r.grow(d, d);
            return r.contains(x, y);
        }
        return super.containsPoint(x, y);
    }

    private void drawBorder(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(this.getFrameColor());
        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
    }

    public void draw(Graphics g) {
        super.draw(g);
        this.drawBorder(g);
        this.drawConnectors(g);
    }

    public HandleEnumeration handles() {
        LineConnection prototype = new LineConnection();
        List handles = CollectionsFactory.current().createList();
        handles.add(new ConnectionHandle(this, RelativeLocator.east(), prototype));
        handles.add(new ConnectionHandle(this, RelativeLocator.west(), prototype));
        handles.add(new ConnectionHandle(this, RelativeLocator.south(), prototype));
        handles.add(new ConnectionHandle(this, RelativeLocator.north(), prototype));
        handles.add(new NullHandle(this, RelativeLocator.southEast()));
        handles.add(new NullHandle(this, RelativeLocator.southWest()));
        handles.add(new NullHandle(this, RelativeLocator.northEast()));
        handles.add(new NullHandle(this, RelativeLocator.northWest()));
        return new HandleEnumerator(handles);
    }

    private void drawConnectors(Graphics g) {
        if (this.fConnectorsVisible) {
            Iterator iter = this.connectors();
            while (iter.hasNext()) {
                ((Connector)iter.next()).draw(g);
            }
        }
    }

    public void connectorVisibility(boolean isVisible, ConnectionFigure courtingConnection) {
        this.fConnectorsVisible = isVisible;
        this.invalidate();
    }

    public Connector connectorAt(int x, int y) {
        return this.findConnector(x, y);
    }

    private Iterator connectors() {
        if (this.fConnectors == null) {
            this.createConnectors();
        }
        return this.fConnectors.iterator();
    }

    private void createConnectors() {
        this.fConnectors = CollectionsFactory.current().createList(4);
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.north()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.south()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.west()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.east()));
    }

    private Connector findConnector(int x, int y) {
        long min = Long.MAX_VALUE;
        Connector closest = null;
        Iterator iter = this.connectors();
        while (iter.hasNext()) {
            Connector c = (Connector)iter.next();
            Point p2 = Geom.center(c.displayBox());
            long d = Geom.length2(x, y, p2.x, p2.y);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    private void initialize() {
        this.setText("node");
        Font fb = new Font("Helvetica", 1, 12);
        this.setFont(fb);
        this.createConnectors();
    }

    public Figure getRepresentingFigure() {
        return this;
    }
}

