/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jhotdraw.applet.DrawApplet;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.contrib.PolygonTool;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.figures.BorderTool;
import org.jhotdraw.figures.ConnectedTextTool;
import org.jhotdraw.figures.ElbowConnection;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.figures.ScribbleTool;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.samples.javadraw.Animator;
import org.jhotdraw.samples.javadraw.BouncingDrawing;
import org.jhotdraw.samples.javadraw.URLTool;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.util.Animatable;

public class JavaDrawApplet
extends DrawApplet {
    private transient JButton fAnimationButton;
    private transient Animator fAnimator;

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JPanel palette) {
        super.createTools(palette);
        AbstractTool tool = new TextTool(this, new TextFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/TEXT", "Text Tool", tool));
        tool = new ConnectedTextTool(this, new TextFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/URL", "URL Tool", tool));
        tool = new CreationTool(this, new RectangleFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this, new RoundRectangleFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this, new EllipseFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new PolygonTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", tool));
        tool = new CreationTool(this, new TriangleFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new CreationTool(this, new DiamondFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/DIAMOND", "Diamond Tool", tool));
        tool = new CreationTool(this, new LineFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this, new LineConnection());
        palette.add(this.createToolButton("/org/jhotdraw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this, new ElbowConnection());
        palette.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", tool));
        tool = new BorderTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/BORDDEC", "Border Tool", tool));
    }

    protected void createButtons(JPanel panel) {
        super.createButtons(panel);
        this.fAnimationButton = new JButton("Start Animation");
        this.fAnimationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JavaDrawApplet.this.toggleAnimation();
            }
        });
        panel.add(this.fAnimationButton);
    }

    protected Drawing createDrawing() {
        return new BouncingDrawing();
    }

    public void startAnimation() {
        if (this.drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.drawing()), this.view());
            this.fAnimator.start();
            this.fAnimationButton.setText("End Animation");
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
            this.fAnimationButton.setText("Start Animation");
        }
    }

    public void toggleAnimation() {
        if (this.fAnimator != null) {
            this.endAnimation();
        } else {
            this.startAnimation();
        }
    }
}

