/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.framework;

import java.io.Serializable;
import org.jhotdraw.framework.JHotDrawRuntimeException;

public class FigureAttributeConstant
implements Serializable,
Cloneable {
    public static final String FRAME_COLOR_STR = "FrameColor";
    public static final FigureAttributeConstant FRAME_COLOR = new FigureAttributeConstant("FrameColor", 1);
    public static final String FILL_COLOR_STR = "FillColor";
    public static final FigureAttributeConstant FILL_COLOR = new FigureAttributeConstant("FillColor", 2);
    public static final String TEXT_COLOR_STR = "TextColor";
    public static final FigureAttributeConstant TEXT_COLOR = new FigureAttributeConstant("TextColor", 3);
    public static final String ARROW_MODE_STR = "ArrowMode";
    public static final FigureAttributeConstant ARROW_MODE = new FigureAttributeConstant("ArrowMode", 4);
    public static final String FONT_NAME_STR = "FontName";
    public static final FigureAttributeConstant FONT_NAME = new FigureAttributeConstant("FontName", 5);
    public static final String FONT_SIZE_STR = "FontSize";
    public static final FigureAttributeConstant FONT_SIZE = new FigureAttributeConstant("FontSize", 6);
    public static final String FONT_STYLE_STR = "FontStyle";
    public static final FigureAttributeConstant FONT_STYLE = new FigureAttributeConstant("FontStyle", 7);
    public static final String URL_STR = "URL";
    public static final FigureAttributeConstant URL = new FigureAttributeConstant("URL", 8);
    public static final String LOCATION_STR = "Location";
    public static final FigureAttributeConstant LOCATION = new FigureAttributeConstant("Location", 9);
    public static final String XALIGNMENT_STR = "XAlignment";
    public static final FigureAttributeConstant XALIGNMENT = new FigureAttributeConstant("XAlignment", 10);
    public static final String YALIGNMENT_STR = "YAlignment";
    public static final FigureAttributeConstant YALIGNMENT = new FigureAttributeConstant("YAlignment", 11);
    public static final String TOP_MARGIN_STR = "TopMargin";
    public static final FigureAttributeConstant TOP_MARGIN = new FigureAttributeConstant("TopMargin", 12);
    public static final String RIGHT_MARGIN_STR = "RightMargin";
    public static final FigureAttributeConstant RIGHT_MARGIN = new FigureAttributeConstant("RightMargin", 13);
    public static final String BOTTOM_MARGIN_STR = "BottomMargin";
    public static final FigureAttributeConstant BOTTOM_MARGIN = new FigureAttributeConstant("BottomMargin", 14);
    public static final String LEFT_MARGIN_STR = "LeftMargin";
    public static final FigureAttributeConstant LEFT_MARGIN = new FigureAttributeConstant("LeftMargin", 15);
    public static final String POPUP_MENU_STR = "PopupMenu";
    public static final FigureAttributeConstant POPUP_MENU = new FigureAttributeConstant("PopupMenu", 16);
    private static FigureAttributeConstant[] attributeConstants;
    private int myID;
    private String myName;

    private FigureAttributeConstant(String newName, int newID) {
        if (attributeConstants == null) {
            attributeConstants = new FigureAttributeConstant[64];
        }
        this.setName(newName);
        this.setID(newID);
        FigureAttributeConstant.addConstant(this);
    }

    public FigureAttributeConstant(String newName) {
        this(newName, attributeConstants.length + 1);
    }

    private void setName(String newName) {
        this.myName = newName;
    }

    public String getName() {
        return this.myName;
    }

    private void setID(int newID) {
        this.myID = newID;
    }

    public int getID() {
        return this.myID;
    }

    public boolean equals(Object compareObject) {
        if (compareObject == null) {
            return false;
        }
        if (!(compareObject instanceof FigureAttributeConstant)) {
            return false;
        }
        FigureAttributeConstant compareAttribute = (FigureAttributeConstant)compareObject;
        if (compareAttribute.getID() != this.getID()) {
            return false;
        }
        if (compareAttribute.getName() == null && this.getName() == null) {
            return true;
        }
        if (compareAttribute.getName() != null && this.getName() != null) {
            return this.getName().equals(compareAttribute.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getID();
    }

    private static void addConstant(FigureAttributeConstant newConstant) {
        int idPos = newConstant.getID() - 1;
        if (idPos < attributeConstants.length && attributeConstants[idPos] != null) {
            throw new JHotDrawRuntimeException("No unique FigureAttribute ID: " + newConstant.getID());
        }
        if (idPos >= attributeConstants.length) {
            FigureAttributeConstant[] tempStrs = new FigureAttributeConstant[idPos + 1];
            System.arraycopy(attributeConstants, 0, tempStrs, 0, attributeConstants.length);
            attributeConstants = tempStrs;
        }
        FigureAttributeConstant.attributeConstants[idPos] = newConstant;
    }

    public static FigureAttributeConstant getConstant(String constantName) {
        int i = 0;
        while (i < attributeConstants.length) {
            FigureAttributeConstant currentAttr = FigureAttributeConstant.getConstant(i);
            if (currentAttr != null && currentAttr.getName() != null && currentAttr.getName().equals(constantName)) {
                return currentAttr;
            }
            ++i;
        }
        return new FigureAttributeConstant(constantName);
    }

    public static FigureAttributeConstant getConstant(int constantId) {
        return attributeConstants[constantId];
    }
}

