/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.FontSizeHandle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.OffsetLocator;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class TextFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fText;
    private Font fFont = TextFigure.createCurrentFont();
    private boolean fIsReadOnly;
    private Figure fObservedFigure = null;
    private OffsetLocator fLocator = null;
    private static String fgCurrentFontName = "Helvetica";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this.setAttribute(FigureAttributeConstant.FILL_COLOR, (Object)ColorMap.color("None"));
        this.fText = "";
        this.fSizeIsDirty = true;
    }

    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this.getLocator() != null) {
            this.getLocator().moveBy(x, y);
        }
        this.changed();
    }

    protected void basicMoveBy(int x, int y) {
        this.fOriginX += x;
        this.fOriginY += y;
    }

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this.fOriginX = newOrigin.x;
        this.fOriginY = newOrigin.y;
    }

    public Rectangle displayBox() {
        Dimension extent = this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, extent.width, extent.height);
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public Font getFont() {
        return this.fFont;
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this.fFont = newFont;
        this.markDirty();
        this.changed();
    }

    public void changed() {
        super.changed();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(FigureAttributeConstant.getConstant(name));
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        Font font = this.getFont();
        if (attributeConstant.equals(FigureAttributeConstant.FONT_SIZE)) {
            return new Integer(font.getSize());
        }
        if (attributeConstant.equals(FigureAttributeConstant.FONT_STYLE)) {
            return new Integer(font.getStyle());
        }
        if (attributeConstant.equals(FigureAttributeConstant.FONT_NAME)) {
            return font.getName();
        }
        return super.getAttribute(attributeConstant);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(FigureAttributeConstant.getConstant(name), value);
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
        Font font = this.getFont();
        if (attributeConstant.equals(FigureAttributeConstant.FONT_SIZE)) {
            Integer s = (Integer)value;
            this.setFont(new Font(font.getName(), font.getStyle(), s));
        } else if (attributeConstant.equals(FigureAttributeConstant.FONT_STYLE)) {
            Integer s = (Integer)value;
            int style = font.getStyle();
            style = s == 0 ? 0 : (style ^= s.intValue());
            this.setFont(new Font(font.getName(), style, font.getSize()));
        } else if (attributeConstant.equals(FigureAttributeConstant.FONT_NAME)) {
            String n = (String)value;
            this.setFont(new Font(n, font.getStyle(), font.getSize()));
        } else {
            super.setAttribute(attributeConstant, value);
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String newText) {
        if (newText == null || !newText.equals(this.fText)) {
            this.willChange();
            this.fText = newText;
            this.markDirty();
            this.changed();
        }
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    public void drawFrame(Graphics g) {
        g.setFont(this.fFont);
        g.setColor((Color)this.getAttribute(FigureAttributeConstant.TEXT_COLOR));
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        Rectangle r = this.displayBox();
        g.drawString(this.getText(), r.x, r.y + metrics.getAscent());
    }

    protected Dimension textExtent() {
        if (!this.fSizeIsDirty) {
            return new Dimension(this.fWidth, this.fHeight);
        }
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        this.fWidth = metrics.stringWidth(this.getText());
        this.fHeight = metrics.getHeight();
        this.fSizeIsDirty = false;
        return new Dimension(this.fWidth, this.fHeight);
    }

    protected void markDirty() {
        this.fSizeIsDirty = true;
    }

    public int overlayColumns() {
        int length = this.getText().length();
        int columns = 20;
        if (length != 0) {
            columns = this.getText().length() + 3;
        }
        return columns;
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        handles.add(new NullHandle(this, RelativeLocator.northWest()));
        handles.add(new NullHandle(this, RelativeLocator.northEast()));
        handles.add(new NullHandle(this, RelativeLocator.southEast()));
        handles.add(new FontSizeHandle(this, RelativeLocator.southWest()));
        return new HandleEnumerator(handles);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        Rectangle r = this.displayBox();
        dw.writeInt(r.x);
        dw.writeInt(r.y);
        dw.writeString(this.getText());
        dw.writeString(this.fFont.getName());
        dw.writeInt(this.fFont.getStyle());
        dw.writeInt(this.fFont.getSize());
        dw.writeBoolean(this.fIsReadOnly);
        dw.writeStorable(this.getObservedFigure());
        dw.writeStorable(this.getLocator());
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.markDirty();
        this.basicDisplayBox(new Point(dr.readInt(), dr.readInt()), null);
        this.setText(dr.readString());
        this.fFont = new Font(dr.readString(), dr.readInt(), dr.readInt());
        this.fIsReadOnly = dr.readBoolean();
        this.setObservedFigure((Figure)dr.readStorable());
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().addFigureChangeListener(this);
        }
        this.setLocator((OffsetLocator)dr.readStorable());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().addFigureChangeListener(this);
        }
        this.markDirty();
    }

    public void connect(Figure figure) {
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().removeFigureChangeListener(this);
        }
        this.setObservedFigure(figure);
        this.setLocator(new OffsetLocator(this.getObservedFigure().connectedTextLocator(this)));
        this.getObservedFigure().addFigureChangeListener(this);
        this.willChange();
        this.updateLocation();
        this.changed();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.willChange();
        this.updateLocation();
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            Rectangle rect = this.invalidateRectangle(this.displayBox());
            this.listener().figureRemoved(new FigureChangeEvent(this, rect, e));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    protected void updateLocation() {
        if (this.getLocator() != null) {
            Point p = this.getLocator().locate(this.getObservedFigure());
            p.x -= this.size().width / 2 + this.fOriginX;
            p.y -= this.size().height / 2 + this.fOriginY;
            if (p.x != 0 || p.y != 0) {
                this.basicMoveBy(p.x, p.y);
            }
        }
    }

    public void release() {
        super.release();
        this.disconnect(this.getObservedFigure());
    }

    public void disconnect(Figure disconnectFigure) {
        if (disconnectFigure != null) {
            disconnectFigure.removeFigureChangeListener(this);
        }
        this.setLocator(null);
        this.setObservedFigure(null);
    }

    protected void setObservedFigure(Figure newObservedFigure) {
        this.fObservedFigure = newObservedFigure;
    }

    public Figure getObservedFigure() {
        return this.fObservedFigure;
    }

    protected void setLocator(OffsetLocator newLocator) {
        this.fLocator = newLocator;
    }

    protected OffsetLocator getLocator() {
        return this.fLocator;
    }

    public TextHolder getTextHolder() {
        return this;
    }

    public static Font createCurrentFont() {
        return new Font(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String name) {
        fgCurrentFontName = name;
    }

    public static void setCurrentFontSize(int size) {
        fgCurrentFontSize = size;
    }

    public static void setCurrentFontStyle(int style) {
        fgCurrentFontStyle = style;
    }
}

