/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class PolyLineHandle
extends LocatorHandle {
    private int fIndex;

    public PolyLineHandle(PolyLineFigure owner, Locator l, int index) {
        super(owner, l);
        this.fIndex = index;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view, this.fIndex));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldPoint(new Point(x, y));
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int currentIndex = ((UndoActivity)this.getUndoActivity()).getPointIndex();
        this.myOwner().setPointAt(new Point(x, y), currentIndex);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        if (x == anchorX && y == anchorY) {
            this.setUndoActivity(null);
        }
    }

    private PolyLineFigure myOwner() {
        return (PolyLineFigure)this.owner();
    }

    protected Undoable createUndoActivity(DrawingView newView, int newPointIndex) {
        return new UndoActivity(newView, newPointIndex);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOldPoint;
        private int myPointIndex;

        public UndoActivity(DrawingView newView, int newPointIndex) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
            this.setPointIndex(newPointIndex);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.movePointToOldLocation();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.movePointToOldLocation();
        }

        protected boolean movePointToOldLocation() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            PolyLineFigure figure = (PolyLineFigure)fe.nextFigure();
            Point backupPoint = figure.pointAt(this.getPointIndex());
            figure.setPointAt(this.getOldPoint(), this.getPointIndex());
            this.setOldPoint(backupPoint);
            return true;
        }

        public void setOldPoint(Point newOldPoint) {
            this.myOldPoint = newOldPoint;
        }

        public Point getOldPoint() {
            return this.myOldPoint;
        }

        public void setPointIndex(int newPointIndex) {
            this.myPointIndex = newPointIndex;
        }

        public int getPointIndex() {
            return this.myPointIndex;
        }
    }
}

