/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.ArrowTip;
import org.jhotdraw.figures.LineDecoration;
import org.jhotdraw.figures.PolyLineConnector;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.figures.PolyLineLocator;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class PolyLineFigure
extends AbstractFigure {
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    protected List fPoints;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Color fFrameColor = Color.black;
    private static final long serialVersionUID = -7951352179906577773L;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this(4);
    }

    public PolyLineFigure(int size) {
        this.fPoints = CollectionsFactory.current().createList(size);
    }

    public PolyLineFigure(int x, int y) {
        this.fPoints = CollectionsFactory.current().createList();
        this.fPoints.add(new Point(x, y));
    }

    public Rectangle displayBox() {
        Iterator iter = this.points();
        if (iter.hasNext()) {
            Rectangle r = new Rectangle((Point)iter.next());
            while (iter.hasNext()) {
                r.add((Point)iter.next());
            }
            return r;
        }
        return new Rectangle();
    }

    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList(this.fPoints.size());
        int i = 0;
        while (i < this.fPoints.size()) {
            handles.add(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
            ++i;
        }
        return new HandleEnumerator(handles);
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public void addPoint(int x, int y) {
        this.fPoints.add(new Point(x, y));
        this.changed();
    }

    public Iterator points() {
        return this.fPoints.iterator();
    }

    public int pointCount() {
        return this.fPoints.size();
    }

    protected void basicMoveBy(int dx, int dy) {
        Iterator iter = this.points();
        while (iter.hasNext()) {
            ((Point)iter.next()).translate(dx, dy);
        }
    }

    public void setPointAt(Point p, int i) {
        this.willChange();
        this.fPoints.set(i, p);
        this.changed();
    }

    public void insertPointAt(Point p, int i) {
        this.fPoints.add(i, p);
        this.changed();
    }

    public void removePointAt(int i) {
        this.willChange();
        this.fPoints.remove(i);
        this.changed();
    }

    public int splitSegment(int x, int y) {
        int i = this.findSegment(x, y);
        if (i != -1) {
            this.insertPointAt(new Point(x, y), i + 1);
        }
        return i + 1;
    }

    public Point pointAt(int i) {
        return (Point)this.fPoints.get(i);
    }

    public boolean joinSegments(int x, int y) {
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            Point p = this.pointAt(i);
            if (Geom.length(x, y, p.x, p.y) < 3L) {
                this.removePointAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Connector connectorAt(int x, int y) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration l) {
        this.fStartDecoration = l;
    }

    public LineDecoration getStartDecoration() {
        return this.fStartDecoration;
    }

    public void setEndDecoration(LineDecoration l) {
        this.fEndDecoration = l;
    }

    public LineDecoration getEndDecoration() {
        return this.fEndDecoration;
    }

    public void draw(Graphics g) {
        g.setColor(this.getFrameColor());
        int i = 0;
        while (i < this.fPoints.size() - 1) {
            Point p1 = this.pointAt(i);
            Point p2 = this.pointAt(i + 1);
            this.drawLine(g, p1.x, p1.y, p2.x, p2.y);
            ++i;
        }
        this.decorate(g);
    }

    protected void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.displayBox();
        bounds.grow(4, 4);
        if (!bounds.contains(x, y)) {
            return false;
        }
        int i = 0;
        while (i < this.fPoints.size() - 1) {
            Point p1 = this.pointAt(i);
            Point p2 = this.pointAt(i + 1);
            if (Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int findSegment(int x, int y) {
        int i = 0;
        while (i < this.fPoints.size() - 1) {
            Point p1 = this.pointAt(i);
            Point p2 = this.pointAt(i + 1);
            if (Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void decorate(Graphics g) {
        if (this.getStartDecoration() != null) {
            Point p1 = this.pointAt(0);
            Point p2 = this.pointAt(1);
            this.getStartDecoration().draw(g, p1.x, p1.y, p2.x, p2.y);
        }
        if (this.getEndDecoration() != null) {
            Point p3 = this.pointAt(this.fPoints.size() - 2);
            Point p4 = this.pointAt(this.fPoints.size() - 1);
            this.getEndDecoration().draw(g, p4.x, p4.y, p3.x, p3.y);
        }
    }

    public Object getAttribute(String name) {
        return this.getAttribute(FigureAttributeConstant.getConstant(name));
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        if (attributeConstant.equals(FigureAttributeConstant.FRAME_COLOR)) {
            return this.getFrameColor();
        }
        if (attributeConstant.equals(FigureAttributeConstant.ARROW_MODE)) {
            int value = 0;
            if (this.getStartDecoration() != null) {
                value |= 1;
            }
            if (this.getEndDecoration() != null) {
                value |= 2;
            }
            return new Integer(value);
        }
        return super.getAttribute(attributeConstant);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(FigureAttributeConstant.getConstant(name), value);
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
        if (attributeConstant.equals(FigureAttributeConstant.FRAME_COLOR)) {
            this.setFrameColor((Color)value);
            this.changed();
        } else if (attributeConstant.equals(FigureAttributeConstant.ARROW_MODE)) {
            Integer intObj = (Integer)value;
            if (intObj != null) {
                int decoration = intObj;
                if ((decoration & 1) != 0) {
                    this.setStartDecoration(new ArrowTip());
                } else {
                    this.setStartDecoration(null);
                }
                if ((decoration & 2) != 0) {
                    this.setEndDecoration(new ArrowTip());
                } else {
                    this.setEndDecoration(null);
                }
            }
            this.changed();
        } else {
            super.setAttribute(attributeConstant, value);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fPoints.size());
        Iterator iter = this.points();
        while (iter.hasNext()) {
            Point p = (Point)iter.next();
            dw.writeInt(p.x);
            dw.writeInt(p.y);
        }
        dw.writeStorable(this.fStartDecoration);
        dw.writeStorable(this.fEndDecoration);
        dw.writeColor(this.fFrameColor);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fPoints = CollectionsFactory.current().createList(size);
        int i = 0;
        while (i < size) {
            int x = dr.readInt();
            int y = dr.readInt();
            this.fPoints.add(new Point(x, y));
            ++i;
        }
        this.setStartDecoration((LineDecoration)dr.readStorable());
        this.setEndDecoration((LineDecoration)dr.readStorable());
        this.fFrameColor = dr.readColor();
    }

    public static Locator locator(int pointIndex) {
        return new PolyLineLocator(pointIndex);
    }

    protected Color getFrameColor() {
        return this.fFrameColor;
    }

    protected void setFrameColor(Color c) {
        this.fFrameColor = c;
    }

    protected Rectangle invalidateRectangle(Rectangle r) {
        Rectangle parentR = super.invalidateRectangle(r);
        if (this.getStartDecoration() != null) {
            parentR.add(this.getStartDecoration().displayBox());
        }
        if (this.getEndDecoration() != null) {
            parentR.add(this.getEndDecoration().displayBox());
        }
        return parentR;
    }
}

