/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.ArrowTip;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.OffsetConnector;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector myStartConnector;
    protected Connector myEndConnector;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    public boolean canConnect() {
        return false;
    }

    protected void basicMoveBy(int dx, int dy) {
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            this.pointAt(i).translate(dx, dy);
            ++i;
        }
        this.updateConnection();
    }

    public void connectStart(Connector newStartConnector) {
        newStartConnector = newStartConnector.finalizeConnector(true);
        this.setStartConnector(newStartConnector);
        if (newStartConnector != null) {
            this.startFigure().addDependendFigure(this);
            this.startFigure().addFigureChangeListener(this);
        }
    }

    public void connectEnd(Connector newEndConnector) {
        newEndConnector = newEndConnector.finalizeConnector(false);
        this.setEndConnector(newEndConnector);
        if (newEndConnector != null) {
            this.endFigure().addDependendFigure(this);
            this.endFigure().addFigureChangeListener(this);
            this.handleConnect(this.startFigure(), this.endFigure());
        }
    }

    public void disconnectStart() {
        this.startFigure().removeFigureChangeListener(this);
        this.startFigure().removeDependendFigure(this);
        this.setStartConnector(null);
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.endFigure().removeDependendFigure(this);
        this.setEndConnector(null);
    }

    public boolean connectsSame(ConnectionFigure other) {
        return other.getStartConnector() == this.getStartConnector() && other.getEndConnector() == this.getEndConnector();
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    public Figure startFigure() {
        if (this.getStartConnector() != null) {
            return this.getStartConnector().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.getEndConnector() != null) {
            return this.getEndConnector().owner();
        }
        return null;
    }

    protected void setStartConnector(Connector newStartConnector) {
        this.myStartConnector = newStartConnector;
    }

    public Connector getStartConnector() {
        return this.myStartConnector;
    }

    protected void setEndConnector(Connector newEndConnector) {
        this.myEndConnector = newEndConnector;
    }

    public Connector getEndConnector() {
        return this.myEndConnector;
    }

    public boolean canConnect(Figure start, Figure end) {
        return true;
    }

    private void resetSelfConnections() {
        while (this.fPoints.size() > 5) {
            this.removePointAt(3);
        }
        while (this.fPoints.size() < 5) {
            this.insertPointAt(this.pointAt(1), 1);
        }
        Rectangle r = this.myStartConnector.owner().displayBox();
        int westX = Geom.west((Rectangle)r).x;
        int eastX = Geom.east((Rectangle)r).x;
        int northY = Geom.north((Rectangle)r).y;
        int southY = Geom.south((Rectangle)r).y;
        int delta = Math.min(24, r.width);
        if (r.width > 200) {
            delta = Math.min(36, r.width);
        }
        if (r.width < 100) {
            delta = Math.min(12, r.width);
        }
        Point p0 = this.pointAt(0);
        OffsetConnector start = (OffsetConnector)this.myStartConnector;
        start.calculateFigureConstrainedOffsets(p0.x, p0.y);
        p0.x = start.locateX();
        p0.y = start.locateY();
        int p4X = eastX;
        double ratio1 = ((double)p0.x - (double)westX) / (double)r.width;
        if (p0.x < westX + r.width / 2) {
            p4X = westX;
            ratio1 = ((double)eastX - (double)p0.x) / (double)r.width;
        }
        int p4Y = northY + (int)(ratio1 * (double)r.height);
        if (p0.y > northY + r.height / 2) {
            p4Y = southY - (int)(ratio1 * (double)r.height);
        }
        OffsetConnector end = (OffsetConnector)this.myEndConnector;
        end.calculateFigureConstrainedOffsets(p4X, p4Y);
        Point p4 = new Point(end.locateX(), end.locateY());
        this.fPoints.set(4, p4);
        int p2X = p4X + delta + (int)(ratio1 * (double)delta);
        if (p0.x < westX + r.width / 2) {
            p2X = p4X - delta - (int)(ratio1 * (double)delta);
        }
        double ratio2 = 1.0 - ratio1;
        int p2Y = northY - delta - (int)(ratio2 * (double)delta);
        if (p0.y > northY + r.height / 2) {
            p2Y = southY + delta + (int)(ratio2 * (double)delta);
        }
        Point p2 = new Point(p2X, p2Y);
        this.fPoints.set(2, p2);
        Point p1 = new Point(p0.x, p2.y);
        Point p3 = new Point(p2.x, p4.y);
        this.fPoints.set(1, p1);
        this.fPoints.set(3, p3);
    }

    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.add(new Point(x, y));
        } else {
            this.fPoints.set(0, new Point(x, y));
        }
        this.changed();
    }

    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.add(new Point(x, y));
        } else {
            this.fPoints.set(this.fPoints.size() - 1, new Point(x, y));
        }
        if (this.myEndConnector != null && this.myStartConnector.owner() == this.myEndConnector.owner() && this.myEndConnector instanceof OffsetConnector) {
            this.resetSelfConnections();
        }
        this.changed();
    }

    public Point startPoint() {
        Point p = this.pointAt(0);
        return new Point(p.x, p.y);
    }

    public Point endPoint() {
        if (this.fPoints.size() > 0) {
            Point p = this.pointAt(this.fPoints.size() - 1);
            return new Point(p.x, p.y);
        }
        return null;
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList(this.fPoints.size());
        handles.add(new ChangeConnectionStartHandle(this));
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            handles.add(new PolyLineHandle(this, LineConnection.locator(i), i));
            ++i;
        }
        handles.add(new ChangeConnectionEndHandle(this));
        return new HandleEnumerator(handles);
    }

    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    public void updateConnection() {
        Point end;
        Point start;
        if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
            this.startPoint(start.x, start.y);
        }
        if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
            this.endPoint(end.x, end.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.updateConnection();
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.getStartConnector() != null) {
            this.startFigure().removeFigureChangeListener(this);
            this.startFigure().removeDependendFigure(this);
        }
        if (this.getEndConnector() != null) {
            this.endFigure().removeFigureChangeListener(this);
            this.endFigure().removeDependendFigure(this);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getStartConnector());
        dw.writeStorable(this.getEndConnector());
    }

    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.getStartConnector() != null) {
            this.connectStart(this.getStartConnector());
        }
        if (this.getEndConnector() != null) {
            this.connectEnd(this.getEndConnector());
        }
    }

    public void visit(FigureVisitor visitor) {
        visitor.visitFigure(this);
    }

    public void removeFromContainer(FigureChangeListener c) {
        super.removeFromContainer(c);
        this.release();
    }
}

