/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class FontSizeHandle
extends LocatorHandle {
    public FontSizeHandle(Figure owner, Locator l) {
        super(owner, l);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        TextFigure textOwner = (TextFigure)this.owner();
        UndoActivity activity = (UndoActivity)this.getUndoActivity();
        int newSize = activity.getFont().getSize() + y - anchorY;
        textOwner.setFont(new Font(activity.getFont().getName(), activity.getFont().getStyle(), newSize));
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        TextFigure textOwner = (TextFigure)this.owner();
        UndoActivity activity = (UndoActivity)this.getUndoActivity();
        if (textOwner.getFont().getSize() == activity.getOldFontSize()) {
            this.setUndoActivity(null);
        } else {
            activity.setFont(textOwner.getFont());
        }
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        TextFigure textOwner = (TextFigure)this.owner();
        return new UndoActivity(newView, textOwner.getFont());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Font myFont;
        private int myOldFontSize;

        public UndoActivity(DrawingView newView, Font newFont) {
            super(newView);
            this.setFont(newFont);
            this.setOldFontSize(this.getFont().getSize());
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.swapFont();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.swapFont();
            return true;
        }

        protected void swapFont() {
            this.setOldFontSize(this.replaceFontSize());
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                ((TextFigure)fe.nextFigure()).setFont(this.getFont());
            }
        }

        private int replaceFontSize() {
            int tempFontSize = this.getFont().getSize();
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getOldFontSize()));
            return tempFontSize;
        }

        protected void setFont(Font newFont) {
            this.myFont = newFont;
        }

        public Font getFont() {
            return this.myFont;
        }

        protected void setOldFontSize(int newOldFontSize) {
            this.myOldFontSize = newOldFontSize;
        }

        public int getOldFontSize() {
            return this.myOldFontSize;
        }
    }
}

