/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jhotdraw.figures.ElbowHandle;
import org.jhotdraw.figures.ElbowTextLocator;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private int elbowConnectionSerializedDataVersion = 1;

    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    public void layoutConnection() {
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList(this.fPoints.size() * 2);
        handles.add(new ChangeConnectionStartHandle(this));
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            handles.add(new NullHandle(this, ElbowConnection.locator(i)));
            ++i;
        }
        handles.add(new ChangeConnectionEndHandle(this));
        i = 0;
        while (i < this.fPoints.size() - 1) {
            handles.add(new ElbowHandle(this, i));
            ++i;
        }
        return new HandleEnumerator(handles);
    }

    public Locator connectedTextLocator(Figure f) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point start = this.startPoint();
        Point end = this.endPoint();
        this.fPoints.clear();
        this.fPoints.add(start);
        if (start.x == end.x || start.y == end.y) {
            this.fPoints.add(end);
        } else {
            Rectangle r1 = this.getStartConnector().owner().displayBox();
            Rectangle r2 = this.getEndConnector().owner().displayBox();
            int dir = Geom.direction(r1.x + r1.width / 2, r1.y + r1.height / 2, r2.x + r2.width / 2, r2.y + r2.height / 2);
            if (dir == 1 || dir == 2) {
                this.fPoints.add(new Point(start.x, (start.y + end.y) / 2));
                this.fPoints.add(new Point(end.x, (start.y + end.y) / 2));
            } else {
                this.fPoints.add(new Point((start.x + end.x) / 2, start.y));
                this.fPoints.add(new Point((start.x + end.x) / 2, end.y));
            }
            this.fPoints.add(end);
        }
        this.changed();
    }
}

