/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.jhotdraw.contrib.html.ContentProducerContext;
import org.jhotdraw.contrib.html.FigureDataContentProducer;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class URLContentProducer
extends FigureDataContentProducer
implements Serializable {
    private URL fURL;

    public URLContentProducer() {
    }

    public URLContentProducer(URL url) {
        this.setURL(url);
    }

    public Object getContent(ContentProducerContext context, String ctxAttrName, Object ctxAttrValue) {
        try {
            URL url = this.getURL() != null ? new URL(this.getURL().toExternalForm()) : new URL(((URL)ctxAttrValue).toExternalForm());
            InputStream reader = url.openStream();
            int available = reader.available();
            byte[] contents = new byte[available];
            reader.read(contents, 0, available);
            reader.close();
            return new String(contents);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.getURL() != null);
        if (this.getURL() != null) {
            dw.writeString(this.getURL().toExternalForm());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        boolean hasURL = dr.readBoolean();
        if (hasURL) {
            this.setURL(new URL(dr.readString()));
        }
    }

    public URL getURL() {
        return this.fURL;
    }

    protected void setURL(URL newURL) {
        this.fURL = newURL;
    }
}

