/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.jhotdraw.contrib.html.AbstractContentProducer;
import org.jhotdraw.contrib.html.ContentProducerContext;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ResourceContentProducer
extends AbstractContentProducer
implements Serializable {
    private String fResourceName;

    public ResourceContentProducer() {
    }

    public ResourceContentProducer(String resourceName) {
        this.setResourceName(resourceName);
    }

    public Object getContent(ContentProducerContext context, String ctxAttrName, Object ctxAttrValue) {
        try {
            String resourceName = this.getResourceName() != null ? this.getResourceName() : (String)ctxAttrValue;
            InputStream reader = this.getClass().getResourceAsStream(resourceName);
            int available = reader.available();
            byte[] contents = new byte[available];
            reader.read(contents, 0, available);
            reader.close();
            return new String(contents);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeString(this.getResourceName());
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setResourceName(dr.readString());
    }

    public String getResourceName() {
        return this.fResourceName;
    }

    protected void setResourceName(String newResourceName) {
        this.fResourceName = newResourceName;
    }
}

