/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.util.Iterator;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManager;
import org.jhotdraw.contrib.html.DisposalThread;
import org.jhotdraw.contrib.html.ResourceDisposabilityStrategy;
import org.jhotdraw.contrib.html.ResourceManagerNotSetException;

public class ETSLADisposalStrategy
implements ResourceDisposabilityStrategy {
    private DisposableResourceManager manager;
    private long gcPeriodicity = 60000L;
    private DisposalThread disposalThread = null;
    private boolean disposingActive = false;

    public ETSLADisposalStrategy() {
    }

    public ETSLADisposalStrategy(long periodicity) {
        this(null, periodicity);
    }

    public ETSLADisposalStrategy(DisposableResourceManager newManager, long newPeriodicity) {
        this.setManager(newManager);
        this.setPeriodicity(newPeriodicity);
        this.initDisposalThread();
    }

    public synchronized void setManager(DisposableResourceManager newManager) {
        if (this.getManager() == null) {
            this.stopDisposing(Long.MAX_VALUE);
        }
        this.manager = newManager;
    }

    public DisposableResourceManager getManager() {
        return this.manager;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        if (this.getManager() == null) {
            throw new ResourceManagerNotSetException();
        }
        if (this.disposingActive) {
            return;
        }
        this.disposingActive = true;
        this.disposalThread.start();
    }

    public void stopDisposing(long millis) {
        if (!this.disposingActive) {
            return;
        }
        try {
            try {
                this.disposalThread.interruptDisposalPending = true;
                this.disposalThread.join(millis);
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            this.disposingActive = false;
        }
    }

    protected void initDisposalThread() {
        if (this.disposalThread != null) {
            return;
        }
        this.disposalThread = new DisposalThread(this, this.getPeriodicity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dispose() {
        DisposableResourceManager disposableResourceManager = this.getManager();
        synchronized (disposableResourceManager) {
            long currentTime = System.currentTimeMillis();
            Iterator resourceIter = this.getManager().getResources();
            while (resourceIter.hasNext()) {
                DisposableResourceHolder resource;
                DisposableResourceHolder disposableResourceHolder = resource = (DisposableResourceHolder)resourceIter.next();
                synchronized (disposableResourceHolder) {
                    if (!resource.isLocked() && resource.getLastTimeAccessed() + resource.getDisposableDelay() < currentTime) {
                        resource.dispose();
                    }
                }
            }
        }
    }

    public long getPeriodicity() {
        return this.gcPeriodicity;
    }

    public void setPeriodicity(long newPeriodicity) {
        this.gcPeriodicity = newPeriodicity;
        if (this.disposalThread != null) {
            this.disposalThread.setPeriodicity(newPeriodicity);
        }
    }
}

