/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManager;
import org.jhotdraw.contrib.html.ETSLADisposalStrategy;
import org.jhotdraw.contrib.html.ResourceDisposabilityStrategy;
import org.jhotdraw.contrib.html.ResourceManagerNotSetException;
import org.jhotdraw.contrib.html.StandardDisposableResourceHolder;
import org.jhotdraw.contrib.html.StandardDisposableResourceManager;

public abstract class DisposableResourceManagerFactory {
    public static long DEFAULT_DISPOSAL_PERIODICITY = 60000L;
    protected static DisposableResourceManager currentManager = null;
    protected static ResourceDisposabilityStrategy currentStrategy = null;
    protected static DisposableResourceHolder holderPrototype = null;

    public static DisposableResourceManager getManager() {
        return currentManager;
    }

    public static void setStrategy(ResourceDisposabilityStrategy strategy) {
        currentStrategy = strategy;
    }

    public static DisposableResourceHolder createStandardHolder(Object resource) {
        DisposableResourceManagerFactory.initManager();
        DisposableResourceHolder holder = (DisposableResourceHolder)holderPrototype.clone();
        holder.setResource(resource);
        DisposableResourceManagerFactory.getManager().registerResource(holder);
        return holder;
    }

    protected static void initManager() {
        if (currentManager == null) {
            if (holderPrototype == null) {
                holderPrototype = new StandardDisposableResourceHolder();
            }
            if (currentStrategy == null) {
                currentStrategy = new ETSLADisposalStrategy(DEFAULT_DISPOSAL_PERIODICITY);
            }
            if (currentManager == null) {
                currentManager = new StandardDisposableResourceManager(currentStrategy);
            }
            try {
                currentManager.startDisposing();
            }
            catch (ResourceManagerNotSetException resourceManagerNotSetException) {
                // empty catch block
            }
        }
    }
}

