/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class JHDDropTargetListener
implements DropTargetListener {
    private int fLastX = 0;
    private int fLastY = 0;
    private Undoable targetUndoable;
    private DrawingView dv;
    private DrawingEditor editor;

    public JHDDropTargetListener(DrawingEditor drawingEditor, DrawingView drawingView) {
        this.dv = drawingView;
        this.editor = drawingEditor;
    }

    protected DrawingView view() {
        return this.dv;
    }

    protected DrawingEditor editor() {
        return this.editor;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        JHDDropTargetListener.log("DropTargetDragEvent-dragEnter");
        this.supportDropTargetDragEvent(dtde);
        if (this.fLastX == 0) {
            this.fLastX = dtde.getLocation().x;
        }
        if (this.fLastY == 0) {
            this.fLastY = dtde.getLocation().y;
        }
    }

    public void dragExit(DropTargetEvent dte) {
        JHDDropTargetListener.log("DropTargetEvent-dragExit");
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.supportDropTargetDragEvent(dtde)) {
            int x = dtde.getLocation().x;
            int y = dtde.getLocation().y;
            if (Math.abs(x - this.fLastX) > 0 || Math.abs(y - this.fLastY) > 0) {
                this.fLastX = x;
                this.fLastY = y;
            }
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        System.out.println("DropTargetDropEvent-drop");
        if (dtde.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            JHDDropTargetListener.log("DNDFiguresFlavor");
            if ((dtde.getDropAction() & 3) != 0) {
                JHDDropTargetListener.log("copy or move");
                if (!dtde.isLocalTransfer()) {
                    System.err.println("Intra-JVM Transfers not implemented for figures yet.");
                    dtde.rejectDrop();
                    return;
                }
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    this.setTargetUndoActivity(this.createTargetUndoActivity(this.view()));
                    DNDFigures ff = (DNDFigures)DNDHelper.processReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dtde.getTransferable());
                    this.getTargetUndoActivity().setAffectedFigures(ff.getFigures());
                    Point theO = ff.getOrigin();
                    this.view().clearSelection();
                    Point newP = dtde.getLocation();
                    int dx = newP.x - theO.x;
                    int dy = newP.y - theO.y;
                    JHDDropTargetListener.log("mouse at " + newP);
                    FigureEnumeration fe = this.view().insertFigures(this.getTargetUndoActivity().getAffectedFigures(), dx, dy, false);
                    this.getTargetUndoActivity().setAffectedFigures(fe);
                    if (dtde.getDropAction() == 2) {
                        this.view().addToSelectionAll(this.getTargetUndoActivity().getAffectedFigures());
                    }
                    this.view().checkDamage();
                    this.editor().getUndoManager().pushUndo(this.getTargetUndoActivity());
                    this.editor().getUndoManager().clearRedos();
                    this.editor().figureSelectionChanged(this.view());
                    dtde.dropComplete(true);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    dtde.dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            JHDDropTargetListener.log("String flavor dropped.");
            dtde.acceptDrop(dtde.getDropAction());
            Object o = DNDHelper.processReceivedData(DataFlavor.stringFlavor, dtde.getTransferable());
            if (o != null) {
                JHDDropTargetListener.log("Received string flavored data.");
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(DNDHelper.ASCIIFlavor)) {
            JHDDropTargetListener.log("ASCII Flavor dropped.");
            dtde.acceptDrop(1);
            Object o = DNDHelper.processReceivedData(DNDHelper.ASCIIFlavor, dtde.getTransferable());
            if (o != null) {
                JHDDropTargetListener.log("Received ASCII Flavored data.");
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            JHDDropTargetListener.log("Java File List Flavor dropped.");
            dtde.acceptDrop(1);
            File[] fList = (File[])DNDHelper.processReceivedData(DataFlavor.javaFileListFlavor, dtde.getTransferable());
            if (fList != null) {
                JHDDropTargetListener.log("Got list of files.");
                int x = 0;
                while (x < fList.length) {
                    System.out.println(fList[x].getAbsolutePath());
                    ++x;
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        }
        this.fLastX = 0;
        this.fLastY = 0;
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        JHDDropTargetListener.log("DropTargetDragEvent-dropActionChanged");
        this.supportDropTargetDragEvent(dtde);
    }

    protected boolean supportDropTargetDragEvent(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            if ((dtde.getDropAction() & 3) != 0) {
                dtde.acceptDrag(dtde.getDropAction());
                return true;
            }
            dtde.rejectDrag();
            return false;
        }
        if (dtde.isDataFlavorSupported(DNDHelper.ASCIIFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        dtde.rejectDrag();
        return false;
    }

    protected Undoable createTargetUndoActivity(DrawingView view) {
        return new AddUndoActivity(view);
    }

    protected void setTargetUndoActivity(Undoable undoable) {
        this.targetUndoable = undoable;
    }

    protected Undoable getTargetUndoActivity() {
        return this.targetUndoable;
    }

    private static void log(String message) {
    }

    public static class AddUndoActivity
    extends UndoableAdapter {
        private boolean undone = false;

        public AddUndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            JHDDropTargetListener.log("AddUndoActivity created " + newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            JHDDropTargetListener.log("AddUndoActivity AddUndoActivity undo");
            DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                f.visit(deleteVisitor);
            }
            this.setAffectedFigures(deleteVisitor.getDeletedFigures());
            this.getDrawingView().clearSelection();
            this.undone = true;
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            JHDDropTargetListener.log("AddUndoActivity redo");
            this.getDrawingView().clearSelection();
            this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
            this.undone = false;
            return true;
        }

        public void release() {
            if (this.undone) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    Figure f = fe.nextFigure();
                    this.getDrawingView().drawing().remove(f);
                    f.release();
                }
            }
            this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

