/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDInterface;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.DragTracker;
import org.jhotdraw.standard.HandleTracker;
import org.jhotdraw.standard.SelectAreaTracker;

public class DragNDropTool
extends AbstractTool {
    private Tool fChild;
    private DragGestureListener dragGestureListener;
    private boolean dragOn;

    public DragNDropTool(DrawingEditor editor) {
        super(editor);
        this.setDragGestureListener(this.createDragGestureListener());
        this.dragOn = false;
    }

    protected void viewCreated(DrawingView view) {
        super.viewCreated(view);
        if (DNDInterface.class.isInstance(view)) {
            DNDInterface dndi = (DNDInterface)((Object)view);
            dndi.DNDInitialize(this.getDragGestureListener());
        }
    }

    protected void viewDestroying(DrawingView view) {
        if (DNDInterface.class.isInstance(view)) {
            DNDInterface dndi = (DNDInterface)((Object)view);
            dndi.DNDDeinitialize();
        }
        super.viewDestroying(view);
    }

    public void activate() {
        super.activate();
        this.setDragOn(true);
    }

    public void deactivate() {
        this.setDragOn(false);
        super.deactivate();
    }

    public static void setCursor(int x, int y, DrawingView view) {
        if (view == null) {
            return;
        }
        Handle handle = view.findHandle(x, y);
        Figure figure = view.drawing().findFigure(x, y);
        if (handle != null) {
            view.setCursor(handle.getCursor());
        } else if (figure != null) {
            view.setCursor(new AWTCursor(13));
        } else {
            view.setCursor(new AWTCursor(0));
        }
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
        if (evt.getSource() == this.getActiveView()) {
            DragNDropTool.setCursor(x, y, this.getActiveView());
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseUp(e, x, y);
            this.fChild = null;
        }
        this.setDragOn(true);
        this.view().unfreezeView();
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(this.getAnchorX(), this.getAnchorY());
        if (handle != null) {
            this.setDragOn(false);
            this.fChild = this.createHandleTracker(handle);
        } else {
            Figure figure = this.drawing().findFigure(this.getAnchorX(), this.getAnchorY());
            if (figure != null) {
                this.fChild = null;
                if (e.isShiftDown()) {
                    this.view().toggleSelection(figure);
                } else if (!this.view().isFigureSelected(figure)) {
                    this.view().clearSelection();
                    this.view().addToSelection(figure);
                }
            } else {
                this.setDragOn(false);
                if (!e.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker();
            }
        }
        if (this.fChild != null) {
            this.fChild.mouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(e, x, y);
        }
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }

    protected Tool createDragTracker(DrawingEditor editor, Figure f) {
        return new DragTracker(editor, f);
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(this.editor(), handle);
    }

    private DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    private void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    protected boolean isDragOn() {
        return this.dragOn;
    }

    protected void setDragOn(boolean isNewDragOn) {
        this.dragOn = isNewDragOn;
    }

    private DragGestureListener createDragGestureListener() {
        return new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                Component c = dge.getComponent();
                if (!DragNDropTool.this.isDragOn()) {
                    return;
                }
                if (c instanceof DrawingView) {
                    boolean found = false;
                    DrawingView dv = (DrawingView)((Object)c);
                    FigureEnumeration selectedElements = dv.selection();
                    if (!selectedElements.hasNextFigure()) {
                        return;
                    }
                    Point p = dge.getDragOrigin();
                    while (selectedElements.hasNextFigure()) {
                        Figure f = selectedElements.nextFigure();
                        if (!f.containsPoint(p.x, p.y)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        DNDFigures dndff = new DNDFigures(dv.selection(), p);
                        DNDFiguresTransferable trans = new DNDFiguresTransferable(dndff);
                        if (c instanceof JComponent) {
                            ((JComponent)c).setAutoscrolls(false);
                        }
                        dge.getDragSource().startDrag(dge, null, trans, ((DNDInterface)((Object)dv)).getDragSourceListener());
                    }
                }
            }
        };
    }
}

