/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;

public class PolygonHandle
extends AbstractHandle {
    private Locator fLocator;
    private int fIndex;

    public PolygonHandle(PolygonFigure owner, Locator l, int index) {
        super(owner);
        this.fLocator = l;
        this.fIndex = index;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view, this.fIndex));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldPoint(new Point(x, y));
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int index = ((PolyLineHandle.UndoActivity)this.getUndoActivity()).getPointIndex();
        this.myOwner().setPointAt(new Point(x, y), index);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.myOwner().smoothPoints();
        if (x == anchorX && y == anchorY) {
            this.setUndoActivity(null);
        }
    }

    public Point locate() {
        return this.fLocator.locate(this.owner());
    }

    private PolygonFigure myOwner() {
        return (PolygonFigure)this.owner();
    }

    protected Undoable createUndoActivity(DrawingView newView, int newPointIndex) {
        return new UndoActivity(newView, newPointIndex);
    }

    public static class UndoActivity
    extends PolyLineHandle.UndoActivity {
        public UndoActivity(DrawingView newView, int newPointIndex) {
            super(newView, newPointIndex);
        }

        protected boolean movePointToOldLocation() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            PolygonFigure figure = (PolygonFigure)fe.nextFigure();
            Point backupPoint = figure.pointAt(this.getPointIndex());
            figure.setPointAt(this.getOldPoint(), this.getPointIndex());
            figure.smoothPoints();
            this.setOldPoint(backupPoint);
            return true;
        }
    }
}

