/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.CreationTool;

public class NestedCreationTool
extends CreationTool {
    private CompositeFigure myContainerFigure;

    public NestedCreationTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        Figure figure = this.drawing().findFigure(e.getX(), e.getY());
        if (figure != null) {
            if ((figure = figure.getDecoratedFigure()) instanceof CompositeFigure) {
                this.setContainerFigure((CompositeFigure)figure);
                super.mouseDown(e, x, y);
            } else {
                this.toolDone();
            }
        } else {
            this.toolDone();
        }
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        if (this.getContainerFigure() != null && !this.getContainerFigure().containsPoint(e.getX(), e.getY())) {
            this.toolDone();
        } else {
            super.mouseMove(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.getContainerFigure() != null && this.getCreatedFigure() != null && this.getContainerFigure().containsPoint(e.getX(), e.getY())) {
            this.getContainerFigure().add(this.getCreatedFigure());
        }
        this.toolDone();
    }

    protected void setContainerFigure(CompositeFigure newContainerFigure) {
        this.myContainerFigure = newContainerFigure;
    }

    public CompositeFigure getContainerFigure() {
        return this.myContainerFigure;
    }

    protected void toolDone() {
        this.setCreatedFigure(null);
        this.setAddedFigure(null);
        this.setContainerFigure(null);
        this.editor().toolDone();
    }
}

