/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JScrollPane;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.framework.DrawingView;

public class JScrollPaneDesktop
extends JScrollPane
implements Desktop {
    private DesktopEventService myDesktopEventService;

    public JScrollPaneDesktop() {
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
    }

    protected Component createContents(DrawingView dv) {
        return (Component)((Object)dv);
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView dv, int location) {
        this.getContainer().add(this.createContents(dv));
    }

    public void removeFromDesktop(DrawingView dv, int location) {
        this.getDesktopEventService().removeComponent(dv);
    }

    public void removeAllFromDesktop(int location) {
        this.getDesktopEventService().removeAllComponents();
    }

    public DrawingView[] getAllFromDesktop(int location) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().addDesktopListener(dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().removeDesktopListener(dpl);
    }

    private Container getContainer() {
        return this.getViewport();
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService newDesktopEventService) {
        this.myDesktopEventService = newDesktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    public void updateTitle(String newDrawingTitle) {
        this.setName(newDrawingTitle);
    }
}

