/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.List;
import java.util.ListIterator;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEvent;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.Helper;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.NullDrawingView;
import org.jhotdraw.util.CollectionsFactory;

public class DesktopEventService {
    private List listeners = CollectionsFactory.current().createList();
    private DrawingView mySelectedView;
    private Container myContainer;
    private Desktop myDesktop;

    public DesktopEventService(Desktop newDesktop, Container newContainer) {
        this.setDesktop(newDesktop);
        this.setContainer(newContainer);
        this.getContainer().addContainerListener(this.createComponentListener());
    }

    private void setDesktop(Desktop newDesktop) {
        this.myDesktop = newDesktop;
    }

    protected Desktop getDesktop() {
        return this.myDesktop;
    }

    private void setContainer(Container newContainer) {
        this.myContainer = newContainer;
    }

    protected Container getContainer() {
        return this.myContainer;
    }

    public void addComponent(Component newComponent) {
        this.getContainer().add(newComponent);
    }

    public void removeComponent(DrawingView dv) {
        Component[] comps = this.getContainer().getComponents();
        int x = 0;
        while (x < comps.length) {
            if (dv == Helper.getDrawingView(comps[x])) {
                this.getContainer().remove(comps[x]);
                break;
            }
            ++x;
        }
    }

    public void removeAllComponents() {
        this.getContainer().removeAll();
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.listeners.add(dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.listeners.remove(dpl);
    }

    protected void fireDrawingViewAddedEvent(DrawingView dv) {
        ListIterator li = this.listeners.listIterator(this.listeners.size());
        DesktopEvent dpe = this.createDesktopEvent(this.getActiveDrawingView(), dv);
        while (li.hasPrevious()) {
            DesktopListener dpl = (DesktopListener)li.previous();
            dpl.drawingViewAdded(dpe);
        }
    }

    protected void fireDrawingViewRemovedEvent(DrawingView dv) {
        ListIterator li = this.listeners.listIterator(this.listeners.size());
        DesktopEvent dpe = this.createDesktopEvent(this.getActiveDrawingView(), dv);
        while (li.hasPrevious()) {
            DesktopListener dpl = (DesktopListener)li.previous();
            dpl.drawingViewRemoved(dpe);
        }
    }

    protected void fireDrawingViewSelectedEvent(DrawingView oldView, DrawingView newView) {
        ListIterator li = this.listeners.listIterator(this.listeners.size());
        DesktopEvent dpe = this.createDesktopEvent(oldView, newView);
        while (li.hasPrevious()) {
            DesktopListener dpl = (DesktopListener)li.previous();
            dpl.drawingViewSelected(dpe);
        }
    }

    protected DesktopEvent createDesktopEvent(DrawingView oldView, DrawingView newView) {
        return new DesktopEvent(this.getDesktop(), newView, oldView);
    }

    public DrawingView[] getDrawingViews(Component[] comps) {
        List al = CollectionsFactory.current().createList();
        int x = 0;
        while (x < comps.length) {
            DrawingView dv = Helper.getDrawingView(comps[x]);
            if (dv != null) {
                al.add(dv);
            }
            ++x;
        }
        DrawingView[] dvs = new DrawingView[al.size()];
        al.toArray(dvs);
        return dvs;
    }

    public DrawingView getActiveDrawingView() {
        return this.mySelectedView;
    }

    protected void setActiveDrawingView(DrawingView newActiveDrawingView) {
        this.mySelectedView = newActiveDrawingView;
    }

    protected ContainerListener createComponentListener() {
        return new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                DrawingView dv = Helper.getDrawingView((Container)e.getChild());
                DrawingView oldView = DesktopEventService.this.getActiveDrawingView();
                if (dv != null) {
                    DesktopEventService.this.fireDrawingViewAddedEvent(dv);
                    DesktopEventService.this.setActiveDrawingView(dv);
                    DesktopEventService.this.fireDrawingViewSelectedEvent(oldView, DesktopEventService.this.getActiveDrawingView());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                DrawingView dv = Helper.getDrawingView((Container)e.getChild());
                if (dv != null) {
                    DrawingView oldView = DesktopEventService.this.getActiveDrawingView();
                    DesktopEventService.this.setActiveDrawingView(NullDrawingView.getManagedDrawingView(oldView.editor()));
                    DesktopEventService.this.fireDrawingViewSelectedEvent(oldView, DesktopEventService.this.getActiveDrawingView());
                    DesktopEventService.this.fireDrawingViewRemovedEvent(dv);
                }
            }
        };
    }
}

