/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.jhotdraw.util.CollectionsFactory;

public class CustomToolBar
extends JToolBar {
    private List standardTools = CollectionsFactory.current().createList();
    private List editTools = CollectionsFactory.current().createList();
    private List currentTools = this.standardTools;
    private boolean needsUpdate = false;

    public void switchToolBar() {
        if (this.currentTools == this.standardTools) {
            this.switchToEditTools();
        } else {
            this.switchToStandardTools();
        }
    }

    public void switchToEditTools() {
        if (this.currentTools != this.editTools) {
            this.currentTools = this.editTools;
            this.needsUpdate = true;
        }
    }

    public void switchToStandardTools() {
        if (this.currentTools != this.standardTools) {
            this.currentTools = this.standardTools;
            this.needsUpdate = true;
        }
    }

    public void activateTools() {
        if (!this.needsUpdate) {
            return;
        }
        this.removeAll();
        JComponent currentTool2 = null;
        for (JComponent currentTool2 : this.currentTools) {
            super.add(currentTool2);
        }
        this.validate();
        this.needsUpdate = false;
    }

    public Component add(Component newTool) {
        if (this.currentTools == this.editTools) {
            this.editTools.add(newTool);
        } else {
            this.standardTools.add(newTool);
        }
        this.needsUpdate = true;
        return super.add(newTool);
    }
}

