/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.jhotdraw.contrib.PopupMenuFigureSelection;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.SelectionTool;

public class CustomSelectionTool
extends SelectionTool {
    public CustomSelectionTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e, x, y);
        } else {
            super.mouseDown(e, x, y);
            this.handleMouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (!e.isPopupTrigger()) {
            super.mouseDrag(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e, x, y);
            super.mouseUp(e, x, y);
        } else if (e.getClickCount() == 2) {
            super.mouseUp(e, x, y);
            this.handleMouseDoubleClick(e, x, y);
        } else {
            super.mouseUp(e, x, y);
            this.handleMouseUp(e, x, y);
            this.handleMouseClick(e, x, y);
        }
    }

    protected void handleMouseDown(MouseEvent e, int x, int y) {
    }

    protected void handleMouseUp(MouseEvent e, int x, int y) {
    }

    protected void handleMouseClick(MouseEvent e, int x, int y) {
    }

    protected void handleMouseDoubleClick(MouseEvent e, int x, int y) {
    }

    protected void handlePopupMenu(MouseEvent e, int x, int y) {
        Figure figure = this.drawing().findFigure(e.getX(), e.getY());
        if (figure != null) {
            Object attribute = figure.getAttribute(FigureAttributeConstant.POPUP_MENU);
            if (attribute == null) {
                figure = this.drawing().findFigureInside(e.getX(), e.getY());
            }
            if (figure != null) {
                this.showPopupMenu(figure, e.getX(), e.getY(), e.getComponent());
            }
        }
    }

    protected void showPopupMenu(Figure figure, int x, int y, Component comp) {
        Object attribute = figure.getAttribute(FigureAttributeConstant.POPUP_MENU);
        if (attribute != null && attribute instanceof JPopupMenu) {
            Point newLocation;
            JPopupMenu popup = (JPopupMenu)attribute;
            if (popup instanceof PopupMenuFigureSelection) {
                ((PopupMenuFigureSelection)((Object)popup)).setSelectedFigure(figure);
            }
            try {
                newLocation = comp.getLocationOnScreen();
            }
            catch (IllegalComponentStateException e) {
                return;
            }
            if (comp instanceof ZoomDrawingView) {
                double scale = ((ZoomDrawingView)comp).getScale();
                x = (int)((double)x * scale);
                y = (int)((double)y * scale);
            }
            newLocation.translate(x, y);
            popup.setLocation(newLocation);
            popup.setInvoker(comp);
            popup.setVisible(true);
        }
    }
}

