/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class AutoscrollHelper {
    private int autoscrollMargin = 20;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public AutoscrollHelper(int margin) {
        this.autoscrollMargin = margin;
    }

    public void setAutoscrollMargin(int margin) {
        this.autoscrollMargin = margin;
    }

    public int getAutoscrollMargin() {
        return this.autoscrollMargin;
    }

    public abstract Dimension getSize();

    public abstract Rectangle getVisibleRect();

    public abstract void scrollRectToVisible(Rectangle var1);

    public void autoscroll(Point location) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        int bottomEdge = rect.y + rect.height;
        int rightEdge = rect.x + rect.width;
        if (location.y - rect.y <= this.autoscrollMargin && rect.y > 0) {
            top = this.autoscrollMargin;
        }
        if (location.x - rect.x <= this.autoscrollMargin && rect.x > 0) {
            left = this.autoscrollMargin;
        }
        if (bottomEdge - location.y <= this.autoscrollMargin && bottomEdge < size.height) {
            bottom = this.autoscrollMargin;
        }
        if (rightEdge - location.x <= this.autoscrollMargin && rightEdge < size.width) {
            right = this.autoscrollMargin;
        }
        rect.x += right - left;
        rect.y += bottom - top;
        this.scrollRectToVisible(rect);
    }

    public Insets getAutoscrollInsets() {
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        this.autoscrollInsets.top = rect.y + this.autoscrollMargin;
        this.autoscrollInsets.left = rect.x + this.autoscrollMargin;
        this.autoscrollInsets.bottom = size.height - (rect.y + rect.height) + this.autoscrollMargin;
        this.autoscrollInsets.right = size.width - (rect.x + rect.width) + this.autoscrollMargin;
        return this.autoscrollInsets;
    }
}

