/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.storedProcedures;

import edu.udo.cs.miningmart.storedProcedures.Attribute;
import edu.udo.cs.miningmart.storedProcedures.BusinessDbConnectionSource;
import edu.udo.cs.miningmart.storedProcedures.DataType;
import edu.udo.cs.miningmart.storedProcedures.DbConnector;
import edu.udo.cs.miningmart.storedProcedures.OutputColumnset;
import edu.udo.cs.miningmart.storedProcedures.Quicksort;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import edu.udo.cs.miningmart.storedProcedures.Windowing;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;

public class WMF {
    public static final int AVERAGE = 0;
    public static final int MODAL = 1;
    public static final int MEDIAN = 2;
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private final double[] weights;
    private final int method;
    private static final int INDEXONATTRIB = 2;

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    public WMF(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, double[] weights, int distance, int method) throws SQLException, TimeOperatorException {
        this.weights = weights;
        this.method = method;
        this.connector = new DbConnector(dbc);
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        Attribute timeAttr = new Attribute(time, timeDT, timeDT);
        Attribute columnAttr = new Attribute(column, columnDT, dbc.getNameOfNumericDatatype());
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeStartAttr = new Attribute(timeStartOut, timeDT, timeDT);
        Attribute timeEndAttr = new Attribute(timeEndOut, timeDT, timeDT);
        Attribute columnOutAttr = new Attribute(columnOut, columnDT, dbc.getNameOfNumericDatatype());
        Attribute[] allAttributes = new Attribute[]{timeStartAttr, timeEndAttr, columnOutAttr};
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(weights.length, distance, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    private double processAverage(String[] window, double[] weights) {
        double sum = 0.0;
        for (int i = 0; i < window.length; ++i) {
            sum += Double.parseDouble(window[i]) * weights[i];
        }
        return sum;
    }

    private double processModal(String[] window, double[] weights) {
        int i;
        double sum = 0.0;
        double[] dblWnd = new double[window.length];
        for (int i2 = 0; i2 < window.length; ++i2) {
            dblWnd[i2] = Double.parseDouble(window[i2]);
        }
        Arrays.sort(dblWnd);
        double[] cnt = new double[dblWnd.length];
        Arrays.fill(cnt, 0.0);
        for (i = 0; i < dblWnd.length - 2; ++i) {
            int cntIndex = i;
            while (dblWnd[i] == dblWnd[i + 1]) {
                int n = cntIndex;
                cnt[n] = cnt[n] + 1.0;
                ++i;
            }
        }
        Quicksort.sort(cnt, dblWnd, 0, dblWnd.length - 1);
        for (i = 0; i < dblWnd.length; ++i) {
            sum += dblWnd[i] * weights[i];
        }
        return sum;
    }

    private double processMedian(String[] window, double[] weights) {
        int i;
        double sum = 0.0;
        double[] dblWnd = new double[window.length];
        for (int i2 = 0; i2 < window.length; ++i2) {
            dblWnd[i2] = Double.parseDouble(window[i2]);
        }
        Arrays.sort(dblWnd);
        double median = dblWnd[dblWnd.length / 2];
        double[] space = new double[dblWnd.length];
        for (i = 0; i < dblWnd.length; ++i) {
            space[i] = Math.abs(median - dblWnd[i]);
        }
        Quicksort.sort(space, dblWnd, 0, dblWnd.length - 1);
        for (i = 0; i < dblWnd.length; ++i) {
            sum += dblWnd[i] * weights[i];
        }
        return sum;
    }

    private void shiftArray(double[] array) {
        for (int i = array.length - 1; i > 0; --i) {
            array[i - 1] = array[i];
        }
    }

    public void calc() throws TimeOperatorException {
        String[] ret = null;
        do {
            ret = this.getWindow().getNextWnd();
            String startTime = this.getWindow().getTimeFirstEntry();
            String endTime = this.getWindow().getTimeLastEntry();
            if (ret == null) continue;
            Double value = null;
            switch (this.method) {
                case 0: {
                    value = new Double(this.processAverage(ret, this.weights));
                    break;
                }
                case 1: {
                    value = new Double(this.processModal(ret, this.weights));
                    break;
                }
                case 2: {
                    value = new Double(this.processMedian(ret, this.weights));
                }
            }
            this.getOutputColumnset().insert(new Object[]{startTime, endTime, value});
        } while (ret != null);
        this.getWindow().close();
        this.connector.close();
    }

    public static void dbWMA(Object dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, String weights, int distance) throws SQLException, TimeOperatorException {
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        double[] numWeights = WMF.parseWeightList(weights);
        if (numWeights == null || numWeights.length == 0) {
            return;
        }
        WMF wmf = new WMF(dbcCasted, source, time, column, target, timeStartOut, timeEndOut, columnOut, numWeights, distance, 0);
        wmf.calc();
        wmf = null;
    }

    private static double[] parseWeightList(String s) {
        if (s == null) {
            return null;
        }
        Vector<Double> values = new Vector<Double>();
        int stop = 0;
        int from = 0;
        while (from < s.length() && (from = WMF.nextNonWhitespace(s, from)) != s.length()) {
            stop = WMF.nextWhitespace(s, from);
            String sub = s.substring(from, stop);
            double d = Double.parseDouble(sub);
            values.add(new Double(d));
            from = stop;
        }
        double[] weights = new double[values.size()];
        for (int arg = 0; arg < weights.length; ++arg) {
            weights[arg] = (Double)values.elementAt(arg);
        }
        return weights;
    }

    private static int nextNonWhitespace(String s, int index) {
        while (index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int nextWhitespace(String s, int index) {
        while (index < s.length() && !Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }
}

